/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.studregistry;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.studregistry.StudRegistry;
import java.util.List;

public class StudRegistryDatabase
implements RepositoryDatasource<StudRegistry, Integer> {
    @Override
    public List<StudRegistry> retrieveAll() {
        return Query.selectAllFrom("STUD_REGISTRY").where(QueryColumn.column("PUBLISHED", true)).getList(this::getFromResultRow);
    }

    private StudRegistry getFromResultRow(ResultRow row) {
        int id = row.getInt("ID");
        String name = row.getString("NAME");
        String identifier = row.getString("IDENTIFIER");
        String description = row.getString("DESCRIPTION");
        String initialRequirementScript = row.getString("INITIAL_REQUIREMENT_SCRIPT");
        String requirementScript = row.getString("REQUIREMENT_SCRIPT");
        double initialFee = row.getDouble("INITIAL_FEE");
        double renewalFee = row.getDouble("RENEWAL_FEE");
        List<Integer> npcIds = this.getNpcsForRegistry(id);
        return new StudRegistry(id, name, identifier, description, initialRequirementScript, requirementScript, initialFee, renewalFee, npcIds);
    }

    private List<Integer> getNpcsForRegistry(int registryId) {
        return Query.selectAllFrom("STUD_REGISTRY_NPC").where(QueryColumn.column("STUD_REGISTRY_ID", registryId)).getList(row -> row.getInt("NPC_ID"));
    }
}

