/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.system;

import com.equestricraft.cdi.Services;
import com.equestricraft.common.ReflectionHelper;
import com.equestricraft.core.system.SubSystem;
import com.equestricraft.core.system.SubSystemStartupException;
import com.equestricraft.logging.Log;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class SubSystemController {
    private static final List<SubSystem> subSystems = new LinkedList<SubSystem>();
    private static final ReentrantLock registrationLock = new ReentrantLock();
    private static boolean registrationComplete = false;
    private static final Log log = Log.getLogger(SubSystemController.class.getName());

    private SubSystemController() {
    }

    public static void startUpSubSystems() throws SubSystemStartupException {
        if (registrationComplete) {
            throw new SubSystemStartupException("An attempt was made to register sub systems when they have already been registered");
        }
        if (registrationLock.tryLock()) {
            try {
                SubSystemController.registerSubSystems();
                SubSystemController.loadSubSystems();
                SubSystemController.enableSubSystems();
                registrationComplete = true;
            }
            catch (Exception ex) {
                log.error("Error loading subsystems", ex);
                throw new SubSystemStartupException(ex);
            }
            finally {
                registrationLock.unlock();
            }
        } else {
            throw new SubSystemStartupException("An attempt was made to register sub systems when they are currently being registered.");
        }
    }

    public static void shutDownSubSystems() {
        SubSystemController.disableSubSystems();
    }

    private static void registerSubSystems() {
        List<Class<SubSystem>> subSystemClasses = ReflectionHelper.scanClassesImplementingType(SubSystem.class);
        subSystemClasses.stream().map(Services::getService).sorted(SubSystemController::sortByPriority).forEach(subSystems::add);
    }

    private static int sortByPriority(SubSystem s1, SubSystem s2) {
        if (s1.priority() == null || s2.priority() == null) {
            throw new IllegalArgumentException("Null priority provided!");
        }
        return s1.priority().ordinal() - s2.priority().ordinal();
    }

    private static void loadSubSystems() {
        for (SubSystem subSystem : subSystems) {
            log.debug("Loading sub system {}", (Object)subSystem.getClass().getName());
            subSystem.onLoad();
        }
    }

    private static void enableSubSystems() {
        for (SubSystem subSystem : subSystems) {
            log.debug("Enabling sub system {}", (Object)subSystem.getClass().getName());
            subSystem.onEnable();
        }
    }

    private static void disableSubSystems() {
        for (SubSystem subSystem : subSystems) {
            log.debug("Disabling sub system {}", (Object)subSystem.getClass().getName());
            subSystem.onDisable();
        }
    }
}

