/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.tack.boots;

import com.equestricraft.base.database.ResultRow;
import com.equestricraft.common.tack.HorseBootsModel;
import com.equestricraft.core.item.ECItemDetails;
import com.equestricraft.core.item.ItemTag;
import com.equestricraft.core.tack.TackDatabase;
import com.equestricraft.core.tack.boots.HorseBoots;
import java.util.List;

public class BootsDatabase
extends TackDatabase<HorseBoots> {
    @Override
    public String getTableName() {
        return "HORSE_BOOTS";
    }

    @Override
    public HorseBoots getFromResultRow(ResultRow row, ECItemDetails details) {
        int id = row.getInt("ID");
        HorseBootsModel model = row.getEnum("MODEL", HorseBootsModel.class);
        double speedOffsetPercentage = row.getDouble("SPEED_OFFSET_PERCENTAGE");
        double maximumStaminaOffsetPercentage = row.getDouble("MAXIMUM_STAMINA_OFFSET_PERCENTAGE");
        long staminaOffsetPerTickOffset = row.getLong("STAMINA_OFFSET_PER_TICK_OFFSET");
        int wearDurationHours = row.getInt("WEAR_DURATION_HOURS");
        int minimumUntrainedFitQuality = row.getInt("MINIMUM_UNTRAINED_FIT_QUALITY");
        int maximumUntrainedFitQuality = row.getInt("MAXIMUM_UNTRAINED_FIT_QUALITY");
        List<ItemTag> tags = this.getTags(details);
        return new HorseBoots(id, details.name(), details.identifier(), details.description(), details.modItemName(), tags, speedOffsetPercentage, maximumStaminaOffsetPercentage, staminaOffsetPerTickOffset, wearDurationHours, minimumUntrainedFitQuality, maximumUntrainedFitQuality, model);
    }
}

