/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.tack.halter;

import com.equestricraft.base.database.ResultRow;
import com.equestricraft.common.tack.HorseHalterModel;
import com.equestricraft.core.item.ECItemDetails;
import com.equestricraft.core.item.ItemTag;
import com.equestricraft.core.tack.TackDatabase;
import com.equestricraft.core.tack.halter.HorseHalter;
import java.util.List;

public class HalterDatabase
extends TackDatabase<HorseHalter> {
    @Override
    public String getTableName() {
        return "HORSE_HALTER";
    }

    @Override
    public HorseHalter getFromResultRow(ResultRow row, ECItemDetails details) {
        int id = row.getInt("ID");
        HorseHalterModel model = row.getEnum("MODEL", HorseHalterModel.class);
        double speedOffsetPercentage = row.getDouble("SPEED_OFFSET_PERCENTAGE");
        double maximumStaminaOffsetPercentage = row.getDouble("MAXIMUM_STAMINA_OFFSET_PERCENTAGE");
        long staminaOffsetPerTickOffset = row.getLong("STAMINA_OFFSET_PER_TICK_OFFSET");
        int wearDurationHours = row.getInt("WEAR_DURATION_HOURS");
        int minimumUntrainedFitQuality = row.getInt("MINIMUM_UNTRAINED_FIT_QUALITY");
        int maximumUntrainedFitQuality = row.getInt("MAXIMUM_UNTRAINED_FIT_QUALITY");
        List<ItemTag> tags = this.getTags(details);
        return new HorseHalter(id, details.name(), details.identifier(), details.description(), details.modItemName(), tags, speedOffsetPercentage, maximumStaminaOffsetPercentage, staminaOffsetPerTickOffset, wearDurationHours, minimumUntrainedFitQuality, maximumUntrainedFitQuality, model);
    }
}

