/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.tack.rein;

import com.equestricraft.base.database.ResultRow;
import com.equestricraft.common.tack.HorseReinModel;
import com.equestricraft.core.item.ECItemDetails;
import com.equestricraft.core.item.ItemTag;
import com.equestricraft.core.tack.TackDatabase;
import com.equestricraft.core.tack.rein.HorseRein;
import java.util.List;

public class HorseReinDatabase
extends TackDatabase<HorseRein> {
    @Override
    public String getTableName() {
        return "HORSE_REIN";
    }

    @Override
    public HorseRein getFromResultRow(ResultRow row, ECItemDetails details) {
        int id = row.getInt("ID");
        HorseReinModel model = row.getEnum("MODEL", HorseReinModel.class);
        double speedOffsetPercentage = row.getDouble("SPEED_OFFSET_PERCENTAGE");
        double maximumStaminaOffsetPercentage = row.getDouble("MAXIMUM_STAMINA_OFFSET_PERCENTAGE");
        long staminaOffsetPerTickOffset = row.getLong("STAMINA_OFFSET_PER_TICK_OFFSET");
        int wearDurationHours = row.getInt("WEAR_DURATION_HOURS");
        int minimumUntrainedFitQuality = row.getInt("MINIMUM_UNTRAINED_FIT_QUALITY");
        int maximumUntrainedFitQuality = row.getInt("MAXIMUM_UNTRAINED_FIT_QUALITY");
        List<ItemTag> tags = this.getTags(details);
        return new HorseRein(id, details.name(), details.identifier(), details.description(), details.modItemName(), tags, speedOffsetPercentage, maximumStaminaOffsetPercentage, staminaOffsetPerTickOffset, wearDurationHours, minimumUntrainedFitQuality, maximumUntrainedFitQuality, model);
    }
}

