/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.tack.saddle;

import com.equestricraft.base.database.ResultRow;
import com.equestricraft.common.tack.HorseSaddleModel;
import com.equestricraft.core.item.ECItemDetails;
import com.equestricraft.core.item.ItemTag;
import com.equestricraft.core.tack.TackDatabase;
import com.equestricraft.core.tack.saddle.HorseSaddle;
import java.util.List;

public class HorseSaddleDatabase
extends TackDatabase<HorseSaddle> {
    @Override
    public String getTableName() {
        return "HORSE_SADDLE";
    }

    @Override
    public HorseSaddle getFromResultRow(ResultRow row, ECItemDetails details) {
        int id = row.getInt("ID");
        HorseSaddleModel model = row.getEnum("MODEL", HorseSaddleModel.class);
        double speedOffsetPercentage = row.getDouble("SPEED_OFFSET_PERCENTAGE");
        double maximumStaminaOffsetPercentage = row.getDouble("MAXIMUM_STAMINA_OFFSET_PERCENTAGE");
        long staminaOffsetPerTickOffset = row.getLong("STAMINA_OFFSET_PER_TICK_OFFSET");
        int wearDurationHours = row.getInt("WEAR_DURATION_HOURS");
        int minimumUntrainedFitQuality = row.getInt("MINIMUM_UNTRAINED_FIT_QUALITY");
        int maximumUntrainedFitQuality = row.getInt("MAXIMUM_UNTRAINED_FIT_QUALITY");
        List<ItemTag> tags = this.getTags(details);
        return new HorseSaddle(id, details.name(), details.identifier(), details.description(), details.modItemName(), tags, speedOffsetPercentage, maximumStaminaOffsetPercentage, staminaOffsetPerTickOffset, wearDurationHours, minimumUntrainedFitQuality, maximumUntrainedFitQuality, model);
    }
}

