/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.trust.level;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.HorsePlayerTrustLevel;
import com.equestricraft.core.trust.level.TrustLevelConfig;
import java.util.List;

public class TrustLevelConfigDatabase
implements RepositoryDatasource<TrustLevelConfig, HorsePlayerTrustLevel> {
    @Override
    public List<TrustLevelConfig> retrieveAll() {
        return Query.selectAllFrom("TRUST_LEVEL").getList(this::getFromResultRow);
    }

    private TrustLevelConfig getFromResultRow(ResultRow row) {
        HorsePlayerTrustLevel trustLevel = row.getEnum("IDENTIFIER", HorsePlayerTrustLevel.class);
        String name = row.getString("NAME");
        int obediencePercentage = row.getInt("OBEDIENCE_PERCENTAGE");
        return new TrustLevelConfig(trustLevel, name, obediencePercentage);
    }
}

