/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.university;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.university.CannotAwardException;
import com.equestricraft.core.player.university.UniversityAwardSession;
import com.equestricraft.core.player.university.degree.NotInDegreeException;
import com.equestricraft.core.player.university.module.UniversityModuleResult;
import com.equestricraft.core.player.university.module.UniversityModuleResultRepository;
import com.equestricraft.core.university.UniversityExamDto;
import com.equestricraft.core.university.UniversityService;
import com.equestricraft.core.university.UniversitySession;
import com.equestricraft.core.university.house.UniversityHouse;
import com.equestricraft.core.university.house.UniversityHouseSession;
import com.equestricraft.core.university.house.point.UniversityHousePointSession;
import com.equestricraft.core.university.module.UniversityModule;
import com.equestricraft.core.university.module.UniversityModuleRepository;
import com.equestricraft.core.university.module.questions.UniversityModuleQuestionDto;
import com.equestricraft.core.university.module.questions.UniversityModuleQuestionSession;
import java.util.List;
import java.util.Optional;

public class UniversityServiceImpl
implements UniversityService {
    @Service
    private UniversityHouseSession universityHouseSession;
    @Service
    private UniversityAwardSession universityAwardSession;
    @Service
    private UniversityModuleRepository universityModuleRepository;
    @Service
    private UniversityModuleQuestionSession universityModuleQuestionSession;
    @Service
    private UniversitySession universitySession;
    @Service
    private UniversityModuleResultRepository universityModuleResultRepository;
    @Service
    private UniversityHousePointSession universityHousePointSession;

    @Override
    public Response awardPointsToPlayersHouse(CorePlayer player, int amount) {
        return player.getUniversity().getHouse().map(h -> this.awardPointsToHouseForPlayer((UniversityHouse)h, player.getId(), amount)).orElseGet(() -> ResponseFactory.fail(I18n.getLabel("university.not-in-house")));
    }

    private Response awardPointsToHouseForPlayer(UniversityHouse universityHouse, int playerId, int amount) {
        this.universityHousePointSession.awardHousePoints(universityHouse.getId(), playerId, amount);
        return ResponseFactory.success(I18n.getLabel("university.points-awarded", amount, universityHouse.getName()));
    }

    @Override
    public int getHousesCurrentPoints(int houseId) {
        return this.universityHousePointSession.getHousesCurrentPoints(houseId);
    }

    @Override
    public Optional<Integer> getPlayersCurrentHousePoints(ECPlayer player) {
        return player.getUniversity().getHouse().map(h -> this.getHousesCurrentPoints(h.getId()));
    }

    @Override
    public Response awardDegree(ECPlayer player, int degreeId) {
        try {
            this.universityAwardSession.awardPlayerWithDegree(player, degreeId);
            return ResponseFactory.success(I18n.getLabel("university.degree-awarded"));
        }
        catch (CannotAwardException | NotInDegreeException ex) {
            return ResponseFactory.fail(ex);
        }
    }

    @Override
    public Optional<Integer> getPlayersPercentageForModule(int playerId, int moduleId) {
        Optional<UniversityModuleResult> result = this.universityModuleResultRepository.findByPlayerAndModule(playerId, moduleId);
        return result.map(UniversityModuleResult::getExamPercentage);
    }

    @Override
    public UniversityExamDto getExam(int moduleId) {
        UniversityModule module = (UniversityModule)this.universityModuleRepository.findByKey(moduleId);
        List<UniversityModuleQuestionDto> questions = this.universityModuleQuestionSession.getQuestionsForModule(moduleId);
        return new UniversityExamDto(module.getId(), module.getName(), questions);
    }

    @Override
    public Response processExamResult(ECPlayer player, int moduleId, int correct, int incorrect) {
        try {
            this.universitySession.processExamResult(player, moduleId, correct, incorrect);
            return ResponseFactory.success();
        }
        catch (EconomyException ex) {
            return ResponseFactory.fail(ex);
        }
    }
}

