/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.university;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.ObjectUtils;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.university.degree.PlayerDegreeInfoDto;
import com.equestricraft.core.player.university.degree.UniversityDegreePlayer;
import com.equestricraft.core.player.university.degree.UniversityDegreePlayerRepository;
import com.equestricraft.core.player.university.module.UniversityModuleResultSession;
import com.equestricraft.core.university.UniversityModuleInfo;
import com.equestricraft.core.university.UniversitySession;
import com.equestricraft.core.university.degree.UniversityDegree;
import com.equestricraft.core.university.degree.UniversityDegreeRepository;
import com.equestricraft.core.university.degreemodule.UniversityDegreeModule;
import com.equestricraft.core.university.degreemodule.UniversityDegreeModuleRepository;
import com.equestricraft.core.university.module.UniversityModule;
import com.equestricraft.core.university.module.UniversityModuleRepository;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class UniversitySessionImpl
implements UniversitySession {
    @Service
    private UniversityDegreePlayerRepository universityDegreePlayerRepository;
    @Service
    private UniversityDegreeRepository universityDegreeRepository;
    @Service
    private UniversityDegreeModuleRepository universityDegreeModuleRepository;
    @Service
    private UniversityModuleRepository universityModuleRepository;
    @Service
    private UniversityModuleResultSession universityModuleResultSession;

    @Override
    public List<UniversityModuleInfo> getModulesPlayerCanAccess(ECPlayer player) {
        List<UniversityDegreePlayer> playerDegrees = this.universityDegreePlayerRepository.findAllByPlayer(player.getId());
        List<Integer> degreeIds = playerDegrees.stream().map(UniversityDegreePlayer::getDegreeId).toList();
        HashSet<UniversityModule> universityModules = new HashSet<UniversityModule>();
        for (Integer degreeId : degreeIds) {
            List<UniversityDegreeModule> degreeModules = this.universityDegreeModuleRepository.findModulesByDegreeId(degreeId);
            List<Integer> moduleIds = degreeModules.stream().map(UniversityDegreeModule::getModuleId).toList();
            List modules = this.universityModuleRepository.findByKeys(moduleIds);
            universityModules.addAll(modules);
        }
        return this.buildModuleInfoList(universityModules);
    }

    private List<UniversityModuleInfo> buildModuleInfoList(Set<UniversityModule> universityModules) {
        return universityModules.stream().map(this::buildModuleInfo).toList();
    }

    private UniversityModuleInfo buildModuleInfo(UniversityModule universityModule) {
        List<UniversityDegreeModule> modulesDegrees = this.universityDegreeModuleRepository.findDegreesByModuleId(universityModule.getId());
        List<Integer> moduleIds = modulesDegrees.stream().map(UniversityDegreeModule::getDegreeId).toList();
        List<UniversityDegree> degrees = this.universityDegreeRepository.findByKeys(moduleIds);
        List<UniversityModuleInfo.DegreeInfo> degreeInfo = this.buildDegreeInfoList(degrees);
        return new UniversityModuleInfo(universityModule.getId(), universityModule.getName(), universityModule.getDescription(), degreeInfo);
    }

    private List<UniversityModuleInfo.DegreeInfo> buildDegreeInfoList(List<UniversityDegree> degrees) {
        return degrees.stream().map(this::buildDegreeInfo).toList();
    }

    private UniversityModuleInfo.DegreeInfo buildDegreeInfo(UniversityDegree universityDegree) {
        return new UniversityModuleInfo.DegreeInfo(universityDegree.getId(), universityDegree.getName());
    }

    @Override
    public List<PlayerDegreeInfoDto> getDegreesListForPlayer(ECPlayer player) {
        List<UniversityDegreePlayer> playersDegrees = this.universityDegreePlayerRepository.findAllByPlayer(player.getId());
        ArrayList<PlayerDegreeInfoDto> toReturn = new ArrayList<PlayerDegreeInfoDto>(this.universityDegreeRepository.getTotalSize());
        for (UniversityDegree degree : this.universityDegreeRepository) {
            PlayerDegreeInfoDto info2 = playersDegrees.stream().filter(d -> d.getDegreeId() == degree.getId()).findFirst().map(d -> this.buildPlayerDegreeInfo(degree, (UniversityDegreePlayer)d)).orElseGet(() -> this.buildPlayerDegreeInfo(degree));
            toReturn.add(info2);
        }
        return toReturn;
    }

    @Override
    public Optional<PlayerDegreeInfoDto> getDegreeInfoForPlayer(ECPlayer player, int degreeId) {
        Optional<UniversityDegreePlayer> degreePlayer = this.universityDegreePlayerRepository.findByPlayerAndDegree(player.getId(), degreeId);
        if (degreePlayer.isPresent()) {
            UniversityDegree degree = (UniversityDegree)this.universityDegreeRepository.findByKey(degreeId);
            return Optional.of(this.buildPlayerDegreeInfo(degree, degreePlayer.get()));
        }
        return Optional.empty();
    }

    private PlayerDegreeInfoDto buildPlayerDegreeInfo(UniversityDegree degree, UniversityDegreePlayer playerDegree) {
        return new PlayerDegreeInfoDto(degree.getId(), degree.getName(), new Date(playerDegree.getStartDate()), ObjectUtils.nullable(playerDegree.getAwardDate(), millis -> new Date((long)millis)), playerDegree.getClassification());
    }

    private PlayerDegreeInfoDto buildPlayerDegreeInfo(UniversityDegree degree) {
        return new PlayerDegreeInfoDto(degree.getId(), degree.getName(), null, null, null);
    }

    @Override
    public void processExamResult(ECPlayer player, int moduleId, int correct, int incorrect) throws EconomyException {
        int totalQuestions = correct + incorrect;
        int percentage = (int)((double)correct / (double)totalQuestions * 100.0);
        this.universityModuleResultSession.setModuleExamResult(player, moduleId, percentage);
    }

    @Override
    public boolean canPlayerAffordToResit(ECPlayer player, int moduleId) {
        if (this.universityModuleResultSession.hasPlayerFailedExam(player, moduleId)) {
            UniversityModule module = (UniversityModule)this.universityModuleRepository.findByKey(moduleId);
            return player.getEconomy().hasBalance(module.getResitFee());
        }
        return true;
    }
}

