/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.university.book;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.coordinate.BlockCoordinate;
import com.equestricraft.core.university.book.UniversityBook;
import java.util.List;

public class UniversityBookDatabase
implements RepositoryDatasource<UniversityBook, Integer> {
    @Override
    public List<UniversityBook> retrieveAll() {
        return Query.selectAllFrom("UNIVERSITY_BOOK").where(QueryColumn.column("ENABLED", true)).getList(this::getFromResultRow);
    }

    private UniversityBook getFromResultRow(ResultRow row) {
        int id = row.getInt("ID");
        String name = row.getString("NAME");
        String description = row.getString("DESCRIPTION");
        String contents = row.getString("CONTENTS");
        BlockCoordinate shelfPosition = row.getBlockCoordinate("SHELF_POSITION");
        return new UniversityBook(id, name, description, contents, shelfPosition);
    }
}

