/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.university.house;

import com.equestricraft.api.common.APIUniversityHouseDto;
import com.equestricraft.api.common.APIUniversityHousePointsDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.university.house.APIUniversityHousePointsDtoImpl;
import com.equestricraft.core.university.house.UniversityHouse;
import com.equestricraft.core.university.house.UniversityHouseSession;
import com.equestricraft.core.university.house.point.HousePointInfo;
import com.equestricraft.core.university.house.point.UniversityHousePointSession;
import java.util.Objects;

public class APIUniversityHouseDtoImpl
implements APIUniversityHouseDto {
    private final UniversityHouse universityHouse;
    @Service
    private static UniversityHousePointSession universityHousePointSession;
    @Service
    private static UniversityHouseSession universityHouseSession;

    public APIUniversityHouseDtoImpl(UniversityHouse universityHouse) {
        this.universityHouse = universityHouse;
    }

    @Override
    public int getId() {
        return this.universityHouse.getId();
    }

    @Override
    public String getName() {
        return this.universityHouse.getName();
    }

    @Override
    public String getChatTag() {
        return this.universityHouse.getChatTag();
    }

    @Override
    public APIUniversityHousePointsDto getPoints() {
        return new APIUniversityHousePointsDtoImpl(this.universityHouse);
    }

    @Override
    public boolean isLeading() {
        return universityHousePointSession.getLeadingHouse().map(HousePointInfo::house).map(this.universityHouse::equals).orElse(false);
    }

    @Override
    public boolean isAcceptingNewMembers() {
        return universityHouseSession.canHouseAcceptNewMembers(this.universityHouse.getId());
    }

    public UniversityHouse getUniversityHouse() {
        return this.universityHouse;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIUniversityHouseDtoImpl that = (APIUniversityHouseDtoImpl)o;
        return Objects.equals(this.universityHouse, that.universityHouse);
    }

    public int hashCode() {
        return Objects.hashCode(this.universityHouse);
    }

    public String toString() {
        return this.getName();
    }
}

