/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.university.house;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.university.UniversitySettings;
import com.equestricraft.core.university.house.UniversityHouse;
import com.equestricraft.core.university.house.UniversityHouseRepository;
import com.equestricraft.core.university.house.UniversityHouseSession;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class UniversityHouseSessionImpl
implements UniversityHouseSession {
    @Service
    private PlayerRepository playerRepository;
    @Service
    private UniversityHouseRepository universityHouseRepository;

    @Override
    public void setPlayersUniversityHouse(CorePlayer player, UniversityHouse house) {
        player.setUniversityHouseId(house.getId());
        player.setUniversityHouseJoinDate(new Date());
        player.save();
    }

    @Override
    public Optional<UniversityHouse> getPlayersUniversityHouse(CorePlayer player) {
        Integer universityHouseId = player.getCorePlayer().getUniversityHouseId();
        if (universityHouseId == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((UniversityHouse)this.universityHouseRepository.findByKey(universityHouseId));
    }

    @Override
    public boolean isPlayerInHouse(CorePlayer player, int houseId) {
        return this.getPlayersUniversityHouse(player).filter(h -> h.getId() == houseId).isPresent();
    }

    @Override
    public int getHouseMemberCount(int houseId) {
        List<CorePlayer> playersInHouse = this.playerRepository.findPlayersInUniversityHouse(houseId);
        return playersInHouse.size();
    }

    @Override
    public boolean canHouseAcceptNewMembers(int houseId) {
        int memberCountOfHouseBeingChecked = this.getHouseMemberCount(houseId);
        if (memberCountOfHouseBeingChecked == 0) {
            return true;
        }
        Integer memberCountOfSmallestHouse = this.getMemberCountOfSmallestHouse();
        if (memberCountOfSmallestHouse == memberCountOfHouseBeingChecked) {
            return true;
        }
        int percentageDifference = 100 - memberCountOfSmallestHouse / memberCountOfHouseBeingChecked * 100;
        return percentageDifference <= UniversitySettings.getHouseMemberDifference();
    }

    private Integer getMemberCountOfSmallestHouse() {
        return this.universityHouseRepository.streamAll().map(h -> this.getHouseMemberCount(h.getId())).min(Comparator.comparingInt(c -> c)).orElseThrow();
    }
}

