/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.university.house.advisor;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.university.house.advisor.UniversityHouseAdvisor;
import com.equestricraft.core.university.house.advisor.UniversityHouseAdvisorKey;
import java.sql.Date;
import java.util.List;

public class UniversityHouseAdvisorDatabase
implements RepositoryDatasource<UniversityHouseAdvisor, UniversityHouseAdvisorKey> {
    private static final String COLUMN_HOUSE_ID = "HOUSE_ID";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_APPOINTMENT_TIME = "APPOINTMENT_TIME";

    @Override
    public void create(UniversityHouseAdvisor universityHouseAdvisor) {
        Query.insertInto("UNIVERSITY_HOUSE_ADVISOR").columns(QueryColumn.column(COLUMN_HOUSE_ID, universityHouseAdvisor.getHouseId()), QueryColumn.column(COLUMN_PLAYER_ID, universityHouseAdvisor.getPlayerId()), QueryColumn.column(COLUMN_APPOINTMENT_TIME, universityHouseAdvisor.getAppointmentTime())).execute();
    }

    @Override
    public List<UniversityHouseAdvisor> retrieveAll() {
        return Query.selectAllFrom("UNIVERSITY_HOUSE_ADVISOR").getList(this::getFromResultRow);
    }

    private UniversityHouseAdvisor getFromResultRow(ResultRow row) {
        int houseId = row.getInt(COLUMN_HOUSE_ID);
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        Date appointmentTime = row.getNullableDate(COLUMN_APPOINTMENT_TIME);
        return new UniversityHouseAdvisor(houseId, playerId, appointmentTime);
    }

    @Override
    public void deleteByKey(UniversityHouseAdvisorKey universityHouseAdvisorKey) {
        Query.deleteFrom("UNIVERSITY_HOUSE_ADVISOR").where(QueryColumn.column(COLUMN_HOUSE_ID, universityHouseAdvisorKey.houseId()), QueryColumn.column(COLUMN_PLAYER_ID, universityHouseAdvisorKey.playerId())).execute();
    }
}

