/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.university.house.advisor;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.university.house.advisor.UniversityHouseAdvisor;
import com.equestricraft.core.university.house.advisor.UniversityHouseAdvisorInfo;
import com.equestricraft.core.university.house.advisor.UniversityHouseAdvisorKey;
import com.equestricraft.core.university.house.advisor.UniversityHouseAdvisorRepository;
import com.equestricraft.core.university.house.advisor.UniversityHouseAdvisorSession;
import java.util.Date;
import java.util.List;

public class UniversityHouseAdvisorSessionImpl
implements UniversityHouseAdvisorSession {
    @Service
    private UniversityHouseAdvisorRepository universityHouseAdvisorRepository;
    @Service
    private PlayerRepository playerRepository;

    @Override
    public void appointPlayerAsAdvisor(ECPlayer player, int houseId) {
        UniversityHouseAdvisor advisor = new UniversityHouseAdvisor(houseId, player.getId(), new Date());
        this.universityHouseAdvisorRepository.add(advisor);
    }

    @Override
    public List<UniversityHouseAdvisorInfo> retrieveAdvisorsForHouse(int houseId) {
        List<UniversityHouseAdvisor> advisors = this.universityHouseAdvisorRepository.findUniversityHouseAdvisorsByHouse(houseId);
        return advisors.stream().map(this::buildAdvisorInfo).toList();
    }

    private UniversityHouseAdvisorInfo buildAdvisorInfo(UniversityHouseAdvisor a) {
        CorePlayer player = (CorePlayer)this.playerRepository.findByKey(a.getPlayerId());
        return new UniversityHouseAdvisorInfo(player.getId(), player.getIgn(), a.getAppointmentTime());
    }

    @Override
    public void removePlayerAsAdvisor(ECPlayer player, int houseId) {
        UniversityHouseAdvisorKey key = new UniversityHouseAdvisorKey(houseId, player.getId());
        this.universityHouseAdvisorRepository.removeByKey(key);
    }
}

