/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.university.house.point;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.university.house.point.UniversityHousePoint;
import java.util.List;

public class UniversityHousePointDatabase
implements RepositoryDatasource<UniversityHousePoint, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_HOUSE_ID = "HOUSE_ID";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_TIME_STAMP = "TIME_STAMP";
    private static final String COLUMN_AMOUNT = "AMOUNT";

    @Override
    public void create(UniversityHousePoint universityHousePoint) {
        Query.insertInto("UNIVERSITY_HOUSE_POINT").columns(QueryColumn.column(COLUMN_HOUSE_ID, universityHousePoint.getHouseId()), QueryColumn.column(COLUMN_PLAYER_ID, universityHousePoint.getPlayerId()), QueryColumn.column(COLUMN_TIME_STAMP, universityHousePoint.getTimeStamp()), QueryColumn.column(COLUMN_AMOUNT, universityHousePoint.getAmount())).executeGetGeneratedKey(universityHousePoint::setId);
    }

    @Override
    public List<UniversityHousePoint> retrieveAll() {
        return Query.selectAllFrom("UNIVERSITY_HOUSE_POINT").getList(this::getFromResultRow);
    }

    private UniversityHousePoint getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        int houseId = row.getInt(COLUMN_HOUSE_ID);
        Integer playerId = row.getNullableInt(COLUMN_PLAYER_ID);
        long timeStamp = row.getLong(COLUMN_TIME_STAMP);
        int amount = row.getInt(COLUMN_AMOUNT);
        return new UniversityHousePoint(id, houseId, playerId, timeStamp, amount);
    }
}

