/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.university.house.point;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.university.house.point.UniversityHousePoint;
import com.equestricraft.core.university.house.point.UniversityHousePointDatabase;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class UniversityHousePointRepository
extends Repository<UniversityHousePoint, Integer> {
    @Service
    private UniversityHousePointDatabase universityHousePointDatabase;

    @Override
    protected RepositoryDatasource<UniversityHousePoint, Integer> getDatasource() {
        return this.universityHousePointDatabase;
    }

    public List<UniversityHousePoint> findAllPointsForHouseSince(int houseId, Date since) {
        RepositorySearchQuery<UniversityHousePoint> query = this.createSearchQuery();
        query.filter(p -> p.getHouseId() == houseId);
        query.filter(p -> p.getTimeStamp() >= since.getTime());
        query.sort(Comparator.comparingLong(UniversityHousePoint::getTimeStamp));
        return query.many();
    }
}

