/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.university.house.point;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.university.house.UniversityHouse;
import com.equestricraft.core.university.house.UniversityHouseRepository;
import com.equestricraft.core.university.house.point.HousePointInfo;
import com.equestricraft.core.university.house.point.UniversityHousePoint;
import com.equestricraft.core.university.house.point.UniversityHousePointRepository;
import com.equestricraft.core.university.house.point.UniversityHousePointSession;
import com.equestricraft.core.university.house.season.UniversityHouseSeason;
import com.equestricraft.core.university.house.season.UniversityHouseSeasonRepository;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class UniversityHousePointSessionImpl
implements UniversityHousePointSession {
    @Service
    private UniversityHousePointRepository universityHousePointRepository;
    @Service
    private UniversityHouseSeasonRepository universityHouseSeasonRepository;
    @Service
    private UniversityHouseRepository universityHouseRepository;

    @Override
    public void awardHousePoints(int houseId, int amount) {
        this.awardHousePoints(houseId, null, amount);
    }

    @Override
    public void awardHousePoints(int houseId, Integer playerId, int amount) {
        UniversityHousePoint housePoint = new UniversityHousePoint(0, houseId, playerId, System.currentTimeMillis(), amount);
        this.universityHousePointRepository.add(housePoint);
    }

    @Override
    public int getHousesCurrentPoints(int houseId) {
        UniversityHouseSeason currentSeason = this.universityHouseSeasonRepository.getCurrentSeason();
        return this.getHousesTotalPointsForSeason(houseId, currentSeason).points();
    }

    @Override
    public List<HousePointInfo> getHousePointsLeaderboard() {
        UniversityHouseSeason currentSeason = this.universityHouseSeasonRepository.getCurrentSeason();
        return this.universityHouseRepository.streamAll().map(h -> this.buildHousePointInfoForSeason((UniversityHouse)h, currentSeason)).filter(h -> h.points() > 0).sorted(Comparator.comparingInt(HousePointInfo::points).reversed().thenComparingLong(HousePointInfo::firstPointsAwarded)).toList();
    }

    private HousePointInfo buildHousePointInfoForSeason(UniversityHouse universityHouse, UniversityHouseSeason currentSeason) {
        HousesSeasonPointsInfo pointsInfo = this.getHousesTotalPointsForSeason(universityHouse.getId(), currentSeason);
        return new HousePointInfo(universityHouse, pointsInfo.points(), pointsInfo.firstPointsGiven());
    }

    private HousesSeasonPointsInfo getHousesTotalPointsForSeason(int houseId, UniversityHouseSeason currentSeason) {
        List<UniversityHousePoint> points = this.universityHousePointRepository.findAllPointsForHouseSince(houseId, currentSeason.getStartTime());
        if (points.isEmpty()) {
            return new HousesSeasonPointsInfo(0, 0L);
        }
        int total = points.stream().mapToInt(UniversityHousePoint::getAmount).sum();
        return new HousesSeasonPointsInfo(total, points.get(0).getTimeStamp());
    }

    @Override
    public Optional<HousePointInfo> getLeadingHouse() {
        List<HousePointInfo> allHousePoints = this.getHousePointsLeaderboard();
        if (allHousePoints.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(allHousePoints.get(0));
    }

    private record HousesSeasonPointsInfo(int points, long firstPointsGiven) {
    }
}

