/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.university.house.season;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.university.house.season.UniversityHouseSeason;
import com.equestricraft.core.university.house.season.UniversityHouseSeasonDatabase;
import java.util.Comparator;

public class UniversityHouseSeasonRepository
extends Repository<UniversityHouseSeason, Integer> {
    @Service
    private UniversityHouseSeasonDatabase universityHouseSeasonDatabase;

    @Override
    protected RepositoryDatasource<UniversityHouseSeason, Integer> getDatasource() {
        return this.universityHouseSeasonDatabase;
    }

    public UniversityHouseSeason getCurrentSeason() {
        RepositorySearchQuery<UniversityHouseSeason> query = this.createSearchQuery();
        query.filter(s -> DateUtils.isInPast(s.getStartTime()));
        query.sortReverse(Comparator.comparing(UniversityHouseSeason::getStartTime));
        return (UniversityHouseSeason)query.single().orElseThrow();
    }
}

