/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.university.module;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.university.module.UniversityModule;
import java.sql.Date;
import java.util.List;

public class UniversityModuleDatabase
implements RepositoryDatasource<UniversityModule, Integer> {
    @Override
    public List<UniversityModule> retrieveAll() {
        return Query.selectAllFrom("UNIVERSITY_MODULE").where(QueryColumn.column("PUBLISHED", true)).getList(this::getFromResultRow);
    }

    private UniversityModule getFromResultRow(ResultRow row) {
        int id = row.getInt("ID");
        String name = row.getString("NAME");
        String identifier = row.getString("IDENTIFIER");
        String description = row.getString("DESCRIPTION");
        String summary = row.getString("SUMMARY");
        Date examLastUpdated = row.getDate("EXAM_LAST_UPDATED");
        int passMark = row.getInt("PASS_MARK");
        boolean requirePracticalExam = row.getBoolean("REQUIRE_PRACTICAL_EXAM");
        double resitFee = row.getDouble("RESIT_FEE");
        int examNpcId = row.getInt("EXAM_NPC_ID");
        return new UniversityModule(id, name, identifier, description, summary, examLastUpdated, passMark, requirePracticalExam, resitFee, examNpcId);
    }
}

