/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.university.module.questions;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.university.module.questions.UniversityModuleQuestion;
import java.util.List;
import java.util.UUID;

public class UniversityModuleQuestionDatabase
implements RepositoryDatasource<UniversityModuleQuestion, UUID> {
    @Override
    public List<UniversityModuleQuestion> retrieveAll() {
        return Query.selectAllFrom("UNIVERSITY_MODULE_QUESTION").getList(this::getFromResultRow);
    }

    private UniversityModuleQuestion getFromResultRow(ResultRow row) {
        UUID id = row.getUuid("ID");
        int moduleId = row.getInt("MODULE_ID");
        int showOrder = row.getInt("SHOW_ORDER");
        String text = row.getString("TEXT");
        String correctAnswer = row.getString("CORRECT_ANSWER");
        String wrongAnswer1 = row.getString("WRONG_ANSWER_1");
        String wrongAnswer2 = row.getNullableString("WRONG_ANSWER_2");
        String wrongAnswer3 = row.getNullableString("WRONG_ANSWER_3");
        return new UniversityModuleQuestion(id, moduleId, showOrder, text, correctAnswer, wrongAnswer1, wrongAnswer2, wrongAnswer3);
    }
}

