/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.university.module.questions;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.university.module.questions.UniversityModuleQuestion;
import com.equestricraft.core.university.module.questions.UniversityModuleQuestionDto;
import com.equestricraft.core.university.module.questions.UniversityModuleQuestionRepository;
import com.equestricraft.core.university.module.questions.UniversityModuleQuestionSession;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class UniversityModuleQuestionSessionImpl
implements UniversityModuleQuestionSession {
    @Service
    private UniversityModuleQuestionRepository universityModuleQuestionRepository;

    @Override
    public List<UniversityModuleQuestionDto> getQuestionsForModule(int moduleId) {
        List<UniversityModuleQuestion> questions = this.universityModuleQuestionRepository.findOrderedQuestionsByModuleId(moduleId);
        return this.buildQuestionDtoList(questions);
    }

    private List<UniversityModuleQuestionDto> buildQuestionDtoList(List<UniversityModuleQuestion> questions) {
        return questions.stream().map(this::buildQuestionDto).toList();
    }

    private UniversityModuleQuestionDto buildQuestionDto(UniversityModuleQuestion question) {
        List<UniversityModuleQuestionDto.QuestionAnswer> answers = this.buildRandomAnswersList(question);
        return new UniversityModuleQuestionDto(question.getId(), question.getText(), answers);
    }

    private List<UniversityModuleQuestionDto.QuestionAnswer> buildRandomAnswersList(UniversityModuleQuestion q) {
        LinkedList<UniversityModuleQuestionDto.QuestionAnswer> answers = new LinkedList<UniversityModuleQuestionDto.QuestionAnswer>();
        answers.add(UniversityModuleQuestionSessionImpl.correctAnswer(q.getCorrectAnswer()));
        answers.add(UniversityModuleQuestionSessionImpl.incorrectAnswer(q.getWrongAnswer1()));
        if (q.getWrongAnswer2() != null) {
            answers.add(UniversityModuleQuestionSessionImpl.incorrectAnswer(q.getWrongAnswer2()));
        }
        if (q.getWrongAnswer3() != null) {
            answers.add(UniversityModuleQuestionSessionImpl.incorrectAnswer(q.getWrongAnswer3()));
        }
        Collections.shuffle(answers);
        return answers;
    }

    private static UniversityModuleQuestionDto.QuestionAnswer correctAnswer(String text) {
        return new UniversityModuleQuestionDto.QuestionAnswer(text, true);
    }

    private static UniversityModuleQuestionDto.QuestionAnswer incorrectAnswer(String text) {
        return new UniversityModuleQuestionDto.QuestionAnswer(text, false);
    }
}

