/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.unscramble;

import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.common.util.StringUtils;
import com.equestricraft.common.util.ThreadUtils;
import com.equestricraft.core.economy.SingleAccountEconomyResponse;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.unscramble.UnscrambleResponse;
import com.equestricraft.core.unscramble.UnscrambleRound;
import com.equestricraft.core.unscramble.UnscrambleSession;
import com.equestricraft.core.unscramble.UnscrambleSettings;
import com.equestricraft.core.unscramble.UnscrambleWord;
import com.equestricraft.core.unscramble.UnscrambleWordRepository;
import com.equestricraft.core.utilities.BroadcastMessageHelper;
import com.equestricraft.logging.Log;
import java.util.List;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;

public class UnscrambleSessionImpl
implements UnscrambleSession {
    @Service
    private UnscrambleWordRepository unscrambleWordRepository;
    private final Timer newRoundStartTimer = new Timer(ThreadUtils.threadName("unscramble-round-timer"));
    private final Timer roundEndTimer = new Timer(ThreadUtils.threadName("unscramble-round-end-timer"));
    private static final Log log = Log.getLogger(UnscrambleSessionImpl.class.getName());

    @Override
    public synchronized void startRound() {
        if (UnscrambleRound.hasCurrent()) {
            return;
        }
        Optional<UnscrambleWord> wordToPlay = this.getRandomWord();
        if (wordToPlay.isPresent()) {
            UnscrambleWord word = wordToPlay.get();
            String scrambled = StringUtils.scrambleNoMixingWords(word.getWord().toLowerCase());
            TimerTask endTask = new TimerTask(){

                @Override
                public void run() {
                    UnscrambleSessionImpl.this.endRound();
                }
            };
            this.roundEndTimer.schedule(endTask, (long)UnscrambleSettings.getRoundDurationSeconds().intValue() * 1000L);
            UnscrambleRound newRound = new UnscrambleRound(word, scrambled, endTask);
            UnscrambleRound.setCurrent(newRound);
            BroadcastMessageHelper.broadcastMessage(I18n.getLabel("unscramble.new-word", scrambled));
        } else {
            this.scheduleNextRound();
        }
    }

    private void endRound() {
        Optional<UnscrambleRound> round = UnscrambleRound.getCurrent();
        if (round.isPresent()) {
            UnscrambleRound.clearCurrent();
            BroadcastMessageHelper.broadcastMessage(I18n.getLabel("unscramble.no-one-guessed", round.get().getWordInPlay().getWord()));
            this.scheduleNextRound();
        } else {
            log.warn("Attempt to end an unscramble round when no round was in progress");
        }
    }

    private void scheduleNextRound() {
        this.newRoundStartTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                UnscrambleSessionImpl.this.startRound();
            }
        }, (long)UnscrambleSettings.getRoundWaitSeconds().intValue() * 1000L);
    }

    @Override
    public synchronized UnscrambleResponse processGuess(ECPlayer player, String guess) {
        String currentWord;
        Optional<UnscrambleRound> round = UnscrambleRound.getCurrent();
        if (round.isPresent() && (currentWord = round.get().getWordInPlay().getWord()).equalsIgnoreCase(guess)) {
            round.get().getEndTask().cancel();
            UnscrambleRound.clearCurrent();
            this.scheduleNextRound();
            BroadcastMessageHelper.broadcastMessage(I18n.getLabel("unscramble.player-guessed-correct", player.getIgn(), currentWord));
            TaskScheduler.executeAsyncTask(() -> {
                SingleAccountEconomyResponse response = player.getEconomy().deposit(UnscrambleSettings.getMoneyReward(), I18n.getLabel("unscramble.win-transaction-line"), "Unscramble");
                player.sendMessage(I18n.getLabel("unscramble.you-won", response.amountFormatted()));
            });
            return UnscrambleResponse.correct(currentWord);
        }
        return UnscrambleResponse.incorrect();
    }

    @Override
    public Optional<String> getCurrentWord() {
        String currentWord;
        Optional<UnscrambleRound> round = UnscrambleRound.getCurrent();
        if (round.isPresent() && (currentWord = round.get().getCurrentWordScrambled()) != null) {
            return Optional.of(currentWord);
        }
        return Optional.empty();
    }

    private Optional<UnscrambleWord> getRandomWord() {
        List<UnscrambleWord> enabled = this.unscrambleWordRepository.findEnabledWords();
        if (enabled.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(ListUtils.getRandomItem(enabled));
    }
}

