/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.warning;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.common.WarningAction;
import com.equestricraft.core.warning.Warning;
import java.sql.Date;
import java.util.List;

public class WarningDatabase {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_PLAYER_WARNED_ID = "PLAYER_WARNED_ID";
    private static final String COLUMN_ISSUED_BY_ID = "ISSUED_BY_ID";
    private static final String COLUMN_GIVEN_TIME = "GIVEN_TIME";
    private static final String COLUMN_SEVERITY_LEVEL = "SEVERITY_LEVEL";
    private static final String COLUMN_REASON_ID = "REASON_ID";
    private static final String COLUMN_MESSAGE = "MESSAGE";
    private static final String COLUMN_ACTION_TAKEN = "ACTION_TAKEN";

    public void addWarning(Warning warning) {
        Query.insertInto("WARNING").columns(QueryColumn.column(COLUMN_PLAYER_WARNED_ID, warning.getPlayerWarnedId()), QueryColumn.column(COLUMN_ISSUED_BY_ID, warning.getIssuedById()), QueryColumn.column(COLUMN_GIVEN_TIME, warning.getTimeGiven()), QueryColumn.column(COLUMN_SEVERITY_LEVEL, warning.getSeverityLevel()), QueryColumn.column(COLUMN_REASON_ID, warning.getReasonId()), QueryColumn.column(COLUMN_MESSAGE, warning.getMessage()), QueryColumn.column(COLUMN_ACTION_TAKEN, warning.getActionTaken())).executeGetGeneratedKey(warning::setId);
    }

    public List<Warning> getWarningsForPlayer(int playerId) {
        return Query.selectAllFrom("WARNING").where(QueryColumn.column(COLUMN_PLAYER_WARNED_ID, playerId)).getList(this::getFromResultRow);
    }

    private Warning getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        int playerWarnedId = row.getInt(COLUMN_PLAYER_WARNED_ID);
        int issuedById = row.getInt(COLUMN_ISSUED_BY_ID);
        Date timeGiven = row.getDate(COLUMN_GIVEN_TIME);
        int severityLevel = row.getInt(COLUMN_SEVERITY_LEVEL);
        int reasonId = row.getInt(COLUMN_REASON_ID);
        String message = row.getString(COLUMN_MESSAGE);
        WarningAction actionTaken = row.getEnum(COLUMN_ACTION_TAKEN, WarningAction.class);
        return new Warning(id, playerWarnedId, issuedById, timeGiven, severityLevel, reasonId, message, actionTaken);
    }
}

