/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.warning;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.WarningAction;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.ban.BanSession;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.warning.Warning;
import com.equestricraft.core.warning.WarningDatabase;
import com.equestricraft.core.warning.WarningDto;
import com.equestricraft.core.warning.WarningGiveResponse;
import com.equestricraft.core.warning.WarningSession;
import com.equestricraft.core.warning.WarningSettings;
import com.equestricraft.core.warning.WarningTransformer;
import com.equestricraft.core.warning.reason.WarningReasonInfo;
import com.equestricraft.logging.Log;
import com.equestricraft.redis.RedisEventBus;
import java.util.Date;
import java.util.List;

public class WarningSessionImpl
implements WarningSession {
    @Service
    private WarningDatabase warningDatabase;
    @Service
    private WarningTransformer warningTransformer;
    @Service
    private BanSession banSession;
    private final RedisEventBus redisEventBus = RedisEventBus.getInstance();
    private static final Log log = Log.getLogger(WarningSessionImpl.class.getName());

    @Override
    public WarningGiveResponse giveWarning(ECPlayer givenTo, ECPlayer givenBy, int severityLevel, WarningReasonInfo reason, String message, WarningAction warningAction) {
        if (givenTo.equals(givenBy)) {
            return new WarningGiveResponse(null, I18n.getLabel("warning.cannot-warn-yourself"));
        }
        if ((message = message.trim()).length() > 255) {
            return new WarningGiveResponse(null, I18n.getLabel("warning.message-character-limit", 255));
        }
        Warning warning = new Warning(0, givenTo.getId(), givenBy.getId(), new Date(), severityLevel, reason.id(), message, warningAction);
        this.warningDatabase.addWarning(warning);
        if (warningAction == WarningAction.TEMP_BAN) {
            this.banSession.banPlayer(givenBy, givenBy, WarningSettings.getTempBanDays(), message);
        }
        if (warningAction == WarningAction.KICK) {
            // empty if block
        }
        log.info("Warning given to player ID {}", (Object)givenTo.getId());
        this.redisEventBus.postEvent("warning_given");
        return new WarningGiveResponse(warning.getId(), null);
    }

    @Override
    public List<WarningDto> retrievePlayersWarnings(int playerId) {
        List<Warning> warnings = this.warningDatabase.getWarningsForPlayer(playerId);
        return this.warningTransformer.toDtoList(warnings);
    }
}

