/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.warning.reason;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.common.WarningAction;
import com.equestricraft.core.warning.reason.WarningReason;
import java.util.List;

public class WarningReasonDatabase {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_DESCRIPTION = "DESCRIPTION";
    private static final String COLUMN_SUGGESTED_ACTION = "SUGGESTED_ACTION";
    private static final String COLUMN_ENABLED = "ENABLED";

    public List<WarningReason> getAllEnabledReasons() {
        return Query.selectAllFrom("WARNING_REASON").where(QueryColumn.column(COLUMN_ENABLED, true)).getList(this::getFromResultRow);
    }

    private WarningReason getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        WarningAction suggestedAction = row.getEnum(COLUMN_SUGGESTED_ACTION, WarningAction.class);
        String description = row.getString(COLUMN_DESCRIPTION);
        return new WarningReason(id, name, description, suggestedAction);
    }
}

