/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.warp;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.core.warp.Warp;
import java.sql.Date;
import java.util.List;

public class WarpDatabase
implements RepositoryDatasource<Warp, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_DESCRIPTION = "DESCRIPTION";
    private static final String COLUMN_LOCATION = "LOCATION";
    private static final String COLUMN_CREATED_BY_PLAYER_ID = "CREATED_BY_PLAYER_ID";
    private static final String COLUMN_CREATED_DATE = "CREATED_DATE";
    private static final String COLUMN_LAST_USED_BY_PLAYER_ID = "LAST_USED_BY_PLAYER_ID";
    private static final String COLUMN_LAST_USED_DATE = "LAST_USED_DATE";

    @Override
    public void create(Warp warp) {
        Query.insertInto("WARP").columns(QueryColumn.column(COLUMN_NAME, warp.getName()), QueryColumn.column(COLUMN_DESCRIPTION, warp.getDescription()), QueryColumn.column(COLUMN_LOCATION, warp.getLocation()), QueryColumn.column(COLUMN_CREATED_BY_PLAYER_ID, warp.getCreatedByPlayerId()), QueryColumn.column(COLUMN_CREATED_DATE, warp.getCreatedDate())).executeGetGeneratedKey(warp::setId);
    }

    @Override
    public List<Warp> retrieveAll() {
        return Query.selectAllFrom("WARP").getList(this::getFromResultRow);
    }

    private Warp getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        String description = row.getString(COLUMN_DESCRIPTION);
        DirectionalCoordinate location = row.getDirectionalCoordinate(COLUMN_LOCATION);
        Integer createdByPlayerId = row.getInt(COLUMN_CREATED_BY_PLAYER_ID);
        Date createdDate = row.getDate(COLUMN_CREATED_DATE);
        Integer lastUsedByPlayerId = row.getNullableInt(COLUMN_LAST_USED_BY_PLAYER_ID);
        Date lastUsedDate = row.getNullableDate(COLUMN_LAST_USED_DATE);
        return new Warp(id, name, description, location, createdByPlayerId, createdDate, lastUsedByPlayerId, lastUsedDate);
    }

    @Override
    public void update(Warp warp) {
        Query.update("WARP").set(QueryColumn.column(COLUMN_DESCRIPTION, warp.getDescription()), QueryColumn.column(COLUMN_LOCATION, warp.getLocation()), QueryColumn.column(COLUMN_LAST_USED_BY_PLAYER_ID, warp.getLastUsedByPlayerId()), QueryColumn.column(COLUMN_LAST_USED_DATE, warp.getLastUsedDate())).where(QueryColumn.column(COLUMN_ID, warp.getId())).execute();
    }

    @Override
    public void deleteByKey(Integer warpId) {
        Query.deleteFrom("WARP").where(QueryColumn.column(COLUMN_ID, warpId)).execute();
    }
}

