/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.weather;

import com.equestricraft.api.common.APIWeatherDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.weather.CurrentWeather;
import com.equestricraft.core.weather.WeatherSession;
import com.equestricraft.core.weather.WeatherType;

public class APIWeatherDtoImpl
implements APIWeatherDto {
    @Service
    private static WeatherSession weatherSession;

    @Override
    public String getProminentWeatherEvent() {
        return weatherSession.getCurrentProminentWeather();
    }

    @Override
    public String getForecast() {
        return weatherSession.getCurrentWeatherDescription();
    }

    @Override
    public int getTemperature() {
        return weatherSession.getCurrentWeather().temperature();
    }

    @Override
    public int getWindSpeed() {
        return weatherSession.getCurrentWeather().windSpeed();
    }

    @Override
    public String getType() {
        return weatherSession.getCurrentWeather().weatherType().getTranslatedName();
    }

    @Override
    public boolean isClear() {
        return weatherSession.getCurrentWeather().weatherType() == WeatherType.CLEAR;
    }

    @Override
    public boolean isCloudy() {
        return weatherSession.getCurrentWeather().weatherType() == WeatherType.CLOUD;
    }

    @Override
    public boolean isRaining() {
        CurrentWeather weather = weatherSession.getCurrentWeather();
        return weather.weatherType() == WeatherType.RAIN && !weather.snowing();
    }

    @Override
    public boolean isHeatwave() {
        return weatherSession.getCurrentWeather().heatwave();
    }

    @Override
    public boolean isFreezing() {
        return weatherSession.getCurrentWeather().freezing();
    }

    @Override
    public boolean isWindy() {
        return weatherSession.getCurrentWeather().highWinds();
    }

    @Override
    public boolean isSnowing() {
        return weatherSession.getCurrentWeather().snowing();
    }

    @Override
    public boolean isThunder() {
        return weatherSession.getCurrentWeather().thunder();
    }

    @Override
    public boolean isFog() {
        return weatherSession.getCurrentWeather().fog();
    }

    public String toString() {
        return this.getForecast();
    }
}

