/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.weather;

import com.equestricraft.common.season.Autumn;
import com.equestricraft.common.season.SeasonVisitor;
import com.equestricraft.common.season.Spring;
import com.equestricraft.common.season.Summer;
import com.equestricraft.common.season.Winter;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.core.weather.config.WeatherConfiguration;
import com.equestricraft.core.weather.config.WeatherConfigurationHandler;

public class TemperatureCalculator
implements SeasonVisitor<Integer> {
    private final WeatherConfigurationHandler weatherConfigurationHandler = WeatherConfigurationHandler.getInstance();

    @Override
    public Integer visit(Spring spring) {
        WeatherConfiguration config = this.weatherConfigurationHandler.getConfig();
        return this.getTemperature(config.getTemperatureRanges().getSpring().getMinimum(), config.getTemperatureRanges().getSpring().getMaximum(), config.getTemperatureExtremes().getSpring().getProbability(), config.getTemperatureExtremes().getSpring().getOffset());
    }

    @Override
    public Integer visit(Summer summer) {
        WeatherConfiguration config = this.weatherConfigurationHandler.getConfig();
        return this.getTemperature(config.getTemperatureRanges().getSummer().getMinimum(), config.getTemperatureRanges().getSummer().getMaximum(), config.getTemperatureExtremes().getSummer().getProbability(), config.getTemperatureExtremes().getSummer().getOffset());
    }

    @Override
    public Integer visit(Autumn autumn) {
        WeatherConfiguration config = this.weatherConfigurationHandler.getConfig();
        return this.getTemperature(config.getTemperatureRanges().getAutumn().getMinimum(), config.getTemperatureRanges().getAutumn().getMaximum(), config.getTemperatureExtremes().getAutumn().getProbability(), config.getTemperatureExtremes().getAutumn().getOffset());
    }

    @Override
    public Integer visit(Winter winter) {
        WeatherConfiguration config = this.weatherConfigurationHandler.getConfig();
        return this.getTemperature(config.getTemperatureRanges().getWinter().getMinimum(), config.getTemperatureRanges().getWinter().getMaximum(), config.getTemperatureExtremes().getWinter().getProbability(), config.getTemperatureExtremes().getWinter().getOffset());
    }

    private int getTemperature(int minimumTemperature, int maximumTemperature, int extremeProbability, int extremeOffset) {
        int temperature = NumberUtils.randomIntInRange(minimumTemperature, maximumTemperature);
        if (this.shouldBeExtreme(extremeProbability)) {
            boolean isHot;
            boolean bl = isHot = temperature >= NumberUtils.average(minimumTemperature, maximumTemperature);
            if (isHot) {
                return maximumTemperature + NumberUtils.randomIntInRange(1, extremeOffset);
            }
            return minimumTemperature - NumberUtils.randomIntInRange(1, extremeOffset);
        }
        return temperature;
    }

    private boolean shouldBeExtreme(int probability) {
        return NumberUtils.randomIntInRange(0, 100) <= probability;
    }
}

