/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.weather;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.weather.WeatherForecast;
import com.equestricraft.core.weather.WeatherForecastType;
import com.equestricraft.core.weather.WeatherType;
import java.sql.Date;
import java.util.List;

public class WeatherForecastDatabase
implements RepositoryDatasource<WeatherForecast, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_MINIMUM_TEMPERATURE = "MINIMUM_TEMPERATURE";
    private static final String COLUMN_MAXIMUM_TEMPERATURE = "MAXIMUM_TEMPERATURE";
    private static final String COLUMN_MINIMUM_WIND_SPEED = "MINIMUM_WIND_SPEED";
    private static final String COLUMN_MAXIMUM_WIND_SPEED = "MAXIMUM_WIND_SPEED";
    private static final String COLUMN_START_TIME = "START_TIME";
    private static final String COLUMN_FORECAST_ID = "FORECAST_ID";
    private static final String COLUMN_WEATHER_TYPE = "WEATHER_TYPE";
    private static final String COLUMN_PROBABILITY = "PROBABILITY";

    @Override
    public void create(WeatherForecast weatherForecast) {
        Query.insertInto("WEATHER_FORECAST").columns(QueryColumn.column(COLUMN_MINIMUM_TEMPERATURE, weatherForecast.getMinimumTemperature()), QueryColumn.column(COLUMN_MAXIMUM_TEMPERATURE, weatherForecast.getMaximumTemperature()), QueryColumn.column(COLUMN_MINIMUM_WIND_SPEED, weatherForecast.getMinimumWindSpeed()), QueryColumn.column(COLUMN_MAXIMUM_WIND_SPEED, weatherForecast.getMaximumWindSpeed()), QueryColumn.column(COLUMN_START_TIME, weatherForecast.getStartTime())).executeGetGeneratedKey(weatherForecast::setId);
        for (WeatherForecastType type : weatherForecast.getWeatherTypes()) {
            this.insertWeatherForecastType(weatherForecast, type);
        }
    }

    private void insertWeatherForecastType(WeatherForecast weatherForecast, WeatherForecastType type) {
        Query.insertInto("WEATHER_FORECAST_TYPE").columns(QueryColumn.column(COLUMN_WEATHER_TYPE, type.getWeatherType()), QueryColumn.column(COLUMN_FORECAST_ID, weatherForecast.getId()), QueryColumn.column(COLUMN_PROBABILITY, type.getProbability())).execute();
    }

    @Override
    public List<WeatherForecast> retrieveAll() {
        return Query.selectAllFrom("WEATHER_FORECAST").getList(this::getFromResultRow);
    }

    private WeatherForecast getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        int minimumTemperature = row.getInt(COLUMN_MINIMUM_TEMPERATURE);
        int maximumTemperature = row.getInt(COLUMN_MAXIMUM_TEMPERATURE);
        int minimumWindSpeed = row.getInt(COLUMN_MINIMUM_WIND_SPEED);
        int maximumWindSpeed = row.getInt(COLUMN_MAXIMUM_WIND_SPEED);
        Date startTime = row.getDate(COLUMN_START_TIME);
        List<WeatherForecastType> types = this.getWeatherTypesForForecast(id);
        return new WeatherForecast(id, minimumTemperature, maximumTemperature, minimumWindSpeed, maximumWindSpeed, startTime, types);
    }

    private List<WeatherForecastType> getWeatherTypesForForecast(int forecastId) {
        return Query.selectAllFrom("WEATHER_FORECAST_TYPE").where(QueryColumn.column(COLUMN_FORECAST_ID, forecastId)).getList(this::getForecastTypeFromResultRow);
    }

    private WeatherForecastType getForecastTypeFromResultRow(ResultRow row) {
        WeatherType weatherType = row.getEnum(COLUMN_WEATHER_TYPE, WeatherType.class);
        int probability = row.getInt(COLUMN_PROBABILITY);
        return new WeatherForecastType(weatherType, probability);
    }
}

