/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.weather;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.weather.WeatherForecast;
import com.equestricraft.core.weather.WeatherForecastDatabase;
import java.util.Comparator;
import java.util.Date;
import java.util.Optional;

public class WeatherForecastRepository
extends Repository<WeatherForecast, Integer> {
    @Service
    private WeatherForecastDatabase weatherForecastDatabase;

    @Override
    protected RepositoryDatasource<WeatherForecast, Integer> getDatasource() {
        return this.weatherForecastDatabase;
    }

    public Optional<WeatherForecast> findLatestWeather() {
        RepositorySearchQuery<WeatherForecast> searchQuery = this.createSearchQuery();
        searchQuery.sortReverse(Comparator.comparing(WeatherForecast::getStartTime));
        return searchQuery.single();
    }

    public Optional<WeatherForecast> findMostRecentWeatherBeforeTime(Date time) {
        RepositorySearchQuery<WeatherForecast> searchQuery = this.createSearchQuery();
        searchQuery.filter(w -> w.getStartTime().before(time));
        searchQuery.sortReverse(Comparator.comparing(WeatherForecast::getStartTime));
        return searchQuery.single();
    }

    public Optional<WeatherForecast> findFirstWeatherAfterTime(Date time) {
        RepositorySearchQuery<WeatherForecast> searchQuery = this.createSearchQuery();
        searchQuery.filter(w -> w.getStartTime().after(time));
        searchQuery.sort(Comparator.comparing(WeatherForecast::getStartTime));
        return searchQuery.single();
    }
}

