/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.weather;

import com.equestricraft.base.database.TransactionManagement;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.season.Season;
import com.equestricraft.common.season.Seasons;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.common.util.MapUtils;
import com.equestricraft.common.util.WeightedListItem;
import com.equestricraft.core.weather.TemperatureCalculator;
import com.equestricraft.core.weather.WeatherForecast;
import com.equestricraft.core.weather.WeatherForecastRepository;
import com.equestricraft.core.weather.WeatherForecastType;
import com.equestricraft.core.weather.WeatherGenerationSession;
import com.equestricraft.core.weather.WeatherProbability;
import com.equestricraft.core.weather.WeatherType;
import com.equestricraft.core.weather.WindSpeedCalculator;
import com.equestricraft.logging.Log;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;

@TransactionManagement
public class WeatherGenerationSessionImpl
implements WeatherGenerationSession {
    @Service
    private WeatherForecastRepository weatherForecastRepository;
    @Service
    private Seasons seasons;
    @Service
    private TemperatureCalculator temperatureCalculator;
    @Service
    private WindSpeedCalculator windSpeedCalculator;
    private final ReentrantLock weatherGenerationLock = new ReentrantLock();
    private static final Log log = Log.getLogger(WeatherGenerationSessionImpl.class.getName());

    @Override
    public void generateWeatherForecasts() {
        if (this.weatherGenerationLock.tryLock()) {
            try {
                Date startFromDate = this.getDateToStartFrom();
                log.debug("Generating weather forecasts, starting from {}", (Object)startFromDate);
                List<WeatherForecast> generated = this.generateWeatherForecastsFromDate(startFromDate);
                this.weatherForecastRepository.add(generated);
                log.debug("Generated {} weather forecasts", (Object)generated.size());
            }
            finally {
                this.weatherGenerationLock.unlock();
            }
        } else {
            log.warn("There was an attempt to generate weather when weather was currently getting generated");
        }
    }

    private Date getDateToStartFrom() {
        Optional<WeatherForecast> latestWeather = this.weatherForecastRepository.findLatestWeather();
        return latestWeather.map(weatherForecast -> DateUtils.futureMillisOffset(weatherForecast.getStartTime(), 86400000L)).orElseGet(this::getLastMidnight);
    }

    private Date getLastMidnight() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(10, 0);
        return calendar.getTime();
    }

    private List<WeatherForecast> generateWeatherForecastsFromDate(Date startFromDate) {
        LinkedList<WeatherForecast> generated = new LinkedList<WeatherForecast>();
        Date currentDate = startFromDate;
        while (this.isDateWithinGenerationLimit(currentDate)) {
            Season season = this.seasons.getSeasonAtTime(currentDate);
            int temp1 = this.getRandomTemperatureForSeason(season);
            int temp2 = this.getRandomTemperatureForSeason(season);
            int minimumTemperature = Math.min(temp1, temp2);
            int maximumTemperature = Math.max(temp1, temp2);
            int wind1 = this.getRandomWindSpeedForSeason(season);
            int wind2 = this.getRandomWindSpeedForSeason(season);
            int minimumWindSpeed = Math.min(wind1, wind2);
            int maximumWindSpeed = Math.max(wind1, wind2);
            List<WeatherForecastType> types = this.generateTypes(season);
            WeatherForecast weatherEvent = new WeatherForecast(0, minimumTemperature, maximumTemperature, minimumWindSpeed, maximumWindSpeed, currentDate, types);
            generated.add(weatherEvent);
            currentDate = new Date(currentDate.getTime() + 86400000L);
        }
        return generated;
    }

    private List<WeatherForecastType> generateTypes(Season season) {
        EnumMap weatherTypeMap = new EnumMap(WeatherType.class);
        for (int i = 0; i < 3; ++i) {
            WeatherType type = this.getRandomWeatherTypeForSeason(season);
            MapUtils.safeAdd(weatherTypeMap, type);
        }
        return weatherTypeMap.entrySet().stream().map(me -> new WeatherForecastType((WeatherType)((Object)((Object)me.getKey())), (Integer)me.getValue())).toList();
    }

    private boolean isDateWithinGenerationLimit(Date date) {
        return DateUtils.millisUntil(date) < 1209600000L;
    }

    private WeatherType getRandomWeatherTypeForSeason(Season season) {
        List<WeatherTypeWithProbability> list = Arrays.stream(WeatherType.values()).map(weatherType -> this.buildProbabilityForSeason((WeatherType)((Object)weatherType), season)).toList();
        WeatherTypeWithProbability randomWeatherType = ListUtils.getRandomWeightedItem(list);
        log.debug("Scheduling {} for season {}", (Object)randomWeatherType.weatherType().getTranslatedName(), (Object)season.getType().getTranslatedName());
        return randomWeatherType.weatherType();
    }

    private WeatherTypeWithProbability buildProbabilityForSeason(WeatherType weatherType, Season season) {
        WeatherProbability weatherProbability = weatherType.getWeatherProbability();
        Integer probability = season.accept(weatherProbability);
        return new WeatherTypeWithProbability(weatherType, probability);
    }

    private int getRandomTemperatureForSeason(Season season) {
        return season.accept(this.temperatureCalculator);
    }

    private int getRandomWindSpeedForSeason(Season season) {
        return season.accept(this.windSpeedCalculator);
    }

    record WeatherTypeWithProbability(WeatherType weatherType, int weight) implements WeightedListItem
    {
        @Override
        public int getWeight() {
            return this.weight();
        }
    }
}

