/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.weather;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.common.util.StringUtils;
import com.equestricraft.core.weather.CurrentWeather;
import com.equestricraft.core.weather.CurrentWeatherContainer;
import com.equestricraft.core.weather.WeatherForecast;
import com.equestricraft.core.weather.WeatherForecastInfo;
import com.equestricraft.core.weather.WeatherForecastRepository;
import com.equestricraft.core.weather.WeatherForecastType;
import com.equestricraft.core.weather.WeatherSession;
import com.equestricraft.core.weather.WeatherType;
import com.equestricraft.core.weather.WeatherUtilities;
import com.equestricraft.core.weather.config.WeatherConfiguration;
import com.equestricraft.core.weather.config.WeatherConfigurationHandler;
import java.time.Duration;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class WeatherSessionImpl
implements WeatherSession {
    @Service
    private WeatherForecastRepository weatherForecastRepository;
    private final WeatherConfigurationHandler weatherConfigurationHandler = WeatherConfigurationHandler.getInstance();
    private final CurrentWeatherContainer currentWeatherContainer = CurrentWeatherContainer.getInstance();

    @Override
    public CurrentWeather updateCurrentWeather() {
        WeatherForecast weather = this.weatherForecastRepository.findMostRecentWeatherBeforeTime(new Date()).orElseThrow();
        WeatherType type = ListUtils.getRandomWeightedItem(weather.getWeatherTypes(), WeatherForecastType::getProbability).getWeatherType();
        int temperature = NumberUtils.randomIntInRange(weather.getMinimumTemperature(), weather.getMaximumTemperature());
        int windSpeed = NumberUtils.randomIntInRange(weather.getMinimumWindSpeed(), weather.getMaximumWindSpeed());
        List<WeatherType> typeList = Collections.singletonList(type);
        CurrentWeather newWeather = new CurrentWeather(type, temperature, WeatherUtilities.formatTemperature(temperature), windSpeed, WeatherUtilities.formatWindSpeed(windSpeed), this.isFreezing(temperature), this.isSnowing(typeList, temperature), this.isThunder(typeList, temperature), this.isHeatwave(temperature), this.isHighWinds(windSpeed), this.isFog(typeList, temperature, windSpeed));
        this.currentWeatherContainer.setCurrentWeather(newWeather);
        return newWeather;
    }

    @Override
    public CurrentWeather getCurrentWeather() {
        return this.currentWeatherContainer.getCurrentWeather();
    }

    @Override
    public String getCurrentProminentWeather() {
        CurrentWeather currentWeather = this.getCurrentWeather();
        return this.getProminentWeather(currentWeather);
    }

    @Override
    public String getCurrentWeatherDescription() {
        WeatherForecastInfo forecast = this.getWeatherInfoForTime(new Date());
        return this.getForecastDescription(forecast);
    }

    @Override
    public WeatherForecastInfo getWeatherInfoForTime(Date time) {
        WeatherForecast weather = this.weatherForecastRepository.findMostRecentWeatherBeforeTime(time).orElseThrow();
        List<WeatherType> type = weather.getWeatherTypes().stream().map(WeatherForecastType::getWeatherType).toList();
        int minimumTemperature = weather.getMinimumTemperature();
        int maximumTemperature = weather.getMaximumTemperature();
        int minimumWindSpeed = weather.getMinimumWindSpeed();
        int maximumWindSpeed = weather.getMaximumWindSpeed();
        return new WeatherForecastInfo(type, minimumTemperature, maximumTemperature, WeatherUtilities.formatTemperature(minimumTemperature), WeatherUtilities.formatTemperature(maximumTemperature), minimumWindSpeed, maximumWindSpeed, WeatherUtilities.formatWindSpeed(minimumWindSpeed), WeatherUtilities.formatWindSpeed(maximumWindSpeed), this.isFreezing(maximumTemperature), this.isSnowing(type, maximumTemperature), this.isThunder(type, minimumTemperature), this.isHeatwave(maximumTemperature), this.isHighWinds(minimumWindSpeed), this.isFog(type, maximumTemperature, maximumWindSpeed));
    }

    private boolean isFreezing(int temperature) {
        return temperature <= this.weatherConfigurationHandler.getConfig().getEventThresholds().getTemperatureFreezingThresholdMaximum();
    }

    private boolean isSnowing(List<WeatherType> types, int temperature) {
        if (types.contains((Object)WeatherType.RAIN)) {
            return temperature <= this.weatherConfigurationHandler.getConfig().getEventThresholds().getTemperatureSnowThresholdMaximum();
        }
        return false;
    }

    private boolean isThunder(List<WeatherType> types, int temperature) {
        if (types.contains((Object)WeatherType.RAIN) || types.contains((Object)WeatherType.CLOUD)) {
            return temperature >= this.weatherConfigurationHandler.getConfig().getEventThresholds().getTemperatureThunderThresholdMinimum();
        }
        return false;
    }

    private boolean isHeatwave(int temperature) {
        return temperature >= this.weatherConfigurationHandler.getConfig().getEventThresholds().getTemperatureHeatwaveThresholdMinimum();
    }

    private boolean isHighWinds(int windSpeed) {
        return windSpeed >= this.weatherConfigurationHandler.getConfig().getEventThresholds().getWindSpeedHighWindThresholdMinimum();
    }

    private boolean isFog(List<WeatherType> weatherType, int temperature, int windSpeed) {
        if (weatherType.contains((Object)WeatherType.RAIN)) {
            return false;
        }
        WeatherConfiguration config = this.weatherConfigurationHandler.getConfig();
        if (windSpeed > config.getEventThresholds().getWindSpeedFogThresholdMaximum()) {
            return false;
        }
        return temperature <= config.getEventThresholds().getTemperatureFogThresholdMaximum();
    }

    @Override
    public String getForecastForTime(Date time) {
        WeatherForecastInfo forecast = this.getWeatherInfoForTime(time);
        return this.getForecastDescription(forecast);
    }

    private String getProminentWeather(CurrentWeather currentWeather) {
        if (currentWeather.thunder()) {
            return I18n.getLabel("weather.prominent.thunder");
        }
        if (currentWeather.snowing()) {
            return I18n.getLabel("weather.prominent.snowing");
        }
        if (currentWeather.heatwave()) {
            return I18n.getLabel("weather.prominent.heatwave");
        }
        if (currentWeather.freezing()) {
            return I18n.getLabel("weather.prominent.freezing");
        }
        if (currentWeather.highWinds()) {
            return I18n.getLabel("weather.prominent.high-winds");
        }
        if (currentWeather.fog()) {
            return I18n.getLabel("weather.prominent.fog");
        }
        return currentWeather.weatherType().getTranslatedName();
    }

    @Override
    public String getForecastDescription(WeatherForecastInfo weatherForecastInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendTemperatureEvent(stringBuilder, weatherForecastInfo);
        stringBuilder.append(" ");
        this.appendWinds(stringBuilder, weatherForecastInfo);
        stringBuilder.append(" ");
        this.appendSkyEvent(stringBuilder, weatherForecastInfo);
        return stringBuilder.toString();
    }

    @Override
    public Duration getDurationSinceLastWeatherChange() {
        Date lastWeatherChange = this.currentWeatherContainer.getLastWeatherChange();
        return DateUtils.durationSince(lastWeatherChange);
    }

    private void appendTemperatureEvent(StringBuilder stringBuilder, WeatherForecastInfo weatherForecastInfo) {
        if (weatherForecastInfo.heatwave()) {
            stringBuilder.append(I18n.getLabel("weather.forecast.heatwave"));
        } else if (weatherForecastInfo.freezing()) {
            stringBuilder.append(I18n.getLabel("weather.forecast.freezing"));
        } else {
            stringBuilder.append(I18n.getLabel("weather.forecast.temperature", weatherForecastInfo.minimumTemperature(), weatherForecastInfo.maximumTemperature()));
        }
    }

    private void appendWinds(StringBuilder stringBuilder, WeatherForecastInfo weatherForecastInfo) {
        if (weatherForecastInfo.highWinds()) {
            stringBuilder.append(I18n.getLabel("weather.forecast.with-high-winds"));
        } else if (weatherForecastInfo.fog()) {
            stringBuilder.append(I18n.getLabel("weather.forecast.with-fog"));
        } else if (weatherForecastInfo.maximumWindSpeed() <= 0) {
            stringBuilder.append(I18n.getLabel("weather.forecast.with-no-wind"));
        } else {
            stringBuilder.append(I18n.getLabel("weather.forecast.with-wind-speeds", weatherForecastInfo.minimumWindSpeed(), weatherForecastInfo.maximumWindSpeed()));
        }
    }

    private void appendSkyEvent(StringBuilder stringBuilder, WeatherForecastInfo weatherForecastInfo) {
        if (weatherForecastInfo.snowing()) {
            stringBuilder.append(I18n.getLabel("weather.forecast.and-snow"));
        } else if (weatherForecastInfo.thunder()) {
            stringBuilder.append(I18n.getLabel("weather.forecast.and-thunder"));
        } else {
            List<String> weatherTypeNames = weatherForecastInfo.weatherTypes().stream().map(WeatherType::getTranslatedName).toList();
            String commaSeparatedList = StringUtils.oxfordCommandSeparate(weatherTypeNames).toLowerCase();
            if (weatherTypeNames.size() == 1) {
                stringBuilder.append(I18n.getLabel("weather.forecast.and-skies", commaSeparatedList));
            } else {
                stringBuilder.append(I18n.getLabel("weather.forecast.and-skies-chances", commaSeparatedList));
            }
        }
    }
}

