/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.weather;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.spook.SpookTrait;
import com.equestricraft.core.horse.stress.HorseStressProvider;
import com.equestricraft.core.weather.CurrentWeather;
import com.equestricraft.core.weather.WeatherSession;
import java.time.Duration;

public class WeatherStressProvider
implements HorseStressProvider {
    @Service
    private WeatherSession weatherSession;

    @Override
    public float getStressPercentage(EQHorse horse) {
        CurrentWeather currentWeather;
        if (horse.getTraits().getValue(SpookTrait.class) > 0.5f && ((currentWeather = this.weatherSession.getCurrentWeather()).thunder() || currentWeather.highWinds())) {
            Duration durationSinceLastWeatherChange = this.weatherSession.getDurationSinceLastWeatherChange();
            float hoursSinceChange = (float)((double)durationSinceLastWeatherChange.toMinutes() / 60.0);
            float percentage = 1.0f - hoursSinceChange;
            return Math.min(0.5f, percentage);
        }
        return 0.0f;
    }
}

