/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.weather;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.weather.WeatherProbability;
import com.equestricraft.core.weather.typeprobability.ClearProbability;
import com.equestricraft.core.weather.typeprobability.CloudProbability;
import com.equestricraft.core.weather.typeprobability.RainProbability;

public enum WeatherType {
    CLEAR("weather.type.clear", new ClearProbability()),
    CLOUD("weather.type.cloudy", new CloudProbability()),
    RAIN("weather.type.rainy", new RainProbability());

    private final String resourceKey;
    private final WeatherProbability weatherProbability;

    private WeatherType(String resourceKey, WeatherProbability weatherProbability) {
        this.resourceKey = resourceKey;
        this.weatherProbability = weatherProbability;
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    public String getTranslatedName() {
        return I18n.getLabel(this.getResourceKey());
    }

    public WeatherProbability getWeatherProbability() {
        return this.weatherProbability;
    }
}

