/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.weather;

import com.equestricraft.common.season.Autumn;
import com.equestricraft.common.season.SeasonVisitor;
import com.equestricraft.common.season.Spring;
import com.equestricraft.common.season.Summer;
import com.equestricraft.common.season.Winter;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.core.weather.config.WeatherConfigurationHandler;
import com.equestricraft.core.weather.config.WeatherWindSpeedMaximums;

public class WindSpeedCalculator
implements SeasonVisitor<Integer> {
    private final WeatherConfigurationHandler weatherConfigurationHandler = WeatherConfigurationHandler.getInstance();

    @Override
    public Integer visit(Spring spring) {
        return NumberUtils.randomIntInRange(0, this.getWindSpeedMaximums().getWindSpeedMaximumSpring());
    }

    @Override
    public Integer visit(Summer summer) {
        return NumberUtils.randomIntInRange(0, this.getWindSpeedMaximums().getWindSpeedMaximumSummer());
    }

    @Override
    public Integer visit(Autumn autumn) {
        return NumberUtils.randomIntInRange(0, this.getWindSpeedMaximums().getWindSpeedMaximumAutumn());
    }

    @Override
    public Integer visit(Winter winter) {
        return NumberUtils.randomIntInRange(0, this.getWindSpeedMaximums().getWindSpeedMaximumWinter());
    }

    private WeatherWindSpeedMaximums getWindSpeedMaximums() {
        return this.weatherConfigurationHandler.getConfig().getWindSpeedMaximums();
    }
}

