/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.weather.config;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.core.weather.config.WeatherConfiguration;
import com.equestricraft.core.weather.config.WeatherEventThresholds;
import com.equestricraft.core.weather.config.WeatherTemperatureExtreme;
import com.equestricraft.core.weather.config.WeatherTemperatureExtremes;
import com.equestricraft.core.weather.config.WeatherTemperatureRange;
import com.equestricraft.core.weather.config.WeatherTemperatureRanges;
import com.equestricraft.core.weather.config.WeatherTypeProbabilities;
import com.equestricraft.core.weather.config.WeatherTypeProbability;
import com.equestricraft.core.weather.config.WeatherWindSpeedMaximums;

public final class WeatherConfigurationDatabase {
    public WeatherConfiguration getWeatherConfig() {
        return Query.selectAllFrom("WEATHER_CONFIGURATION").getSingle(this::getFromResultRow).orElseThrow();
    }

    private WeatherConfiguration getFromResultRow(ResultRow row) {
        WeatherEventThresholds weatherEventsThresholds = this.getEventThresholds(row);
        WeatherTypeProbabilities weatherProbabilities = this.getProbabilities(row);
        WeatherTemperatureRanges weatherTemperatureRanges = this.getTemperatureRanges(row);
        WeatherTemperatureExtremes weatherTemperatureExtremeProbabilities = this.getExtremeProbabilities(row);
        WeatherWindSpeedMaximums windSpeedMaximums = this.getWindSpeedMaximums(row);
        return new WeatherConfiguration(weatherEventsThresholds, weatherProbabilities, weatherTemperatureRanges, weatherTemperatureExtremeProbabilities, windSpeedMaximums);
    }

    private WeatherEventThresholds getEventThresholds(ResultRow row) {
        int temperatureFreezingThresholdMaximum = row.getInt("TEMPERATURE_FREEZING_THRESHOLD_MAXIMUM");
        int temperatureSnowThresholdMaximum = row.getInt("TEMPERATURE_SNOW_THRESHOLD_MAXIMUM");
        int temperatureThunderThresholdMinimum = row.getInt("TEMPERATURE_THUNDER_THRESHOLD_MINIMUM");
        int temperatureHeatwaveThresholdMinimum = row.getInt("TEMPERATURE_HEATWAVE_THRESHOLD_MINIMUM");
        int windSpeedHighWindThresholdMinimum = row.getInt("WIND_SPEED_HIGH_WIND_THRESHOLD_MINIMUM");
        int windSpeedFogThresholdMaximum = row.getInt("WIND_SPEED_FOG_THRESHOLD_MAXIMUM");
        int temperatureFogThresholdMaximum = row.getInt("TEMPERATURE_FOG_THRESHOLD_MAXIMUM");
        return new WeatherEventThresholds(temperatureFreezingThresholdMaximum, temperatureSnowThresholdMaximum, temperatureThunderThresholdMinimum, temperatureHeatwaveThresholdMinimum, windSpeedHighWindThresholdMinimum, windSpeedFogThresholdMaximum, temperatureFogThresholdMaximum);
    }

    private WeatherTypeProbabilities getProbabilities(ResultRow row) {
        int clearSpring = row.getInt("CLEAR_PROBABILITY_SPRING");
        int clearSummer = row.getInt("CLEAR_PROBABILITY_SUMMER");
        int clearAutumn = row.getInt("CLEAR_PROBABILITY_AUTUMN");
        int clearWinter = row.getInt("CLEAR_PROBABILITY_WINTER");
        WeatherTypeProbability clear = new WeatherTypeProbability(clearSpring, clearSummer, clearAutumn, clearWinter);
        int cloudySpring = row.getInt("CLOUDY_PROBABILITY_SPRING");
        int cloudySummer = row.getInt("CLOUDY_PROBABILITY_SUMMER");
        int cloudyAutumn = row.getInt("CLOUDY_PROBABILITY_AUTUMN");
        int cloudyWinter = row.getInt("CLOUDY_PROBABILITY_WINTER");
        WeatherTypeProbability cloudy = new WeatherTypeProbability(cloudySpring, cloudySummer, cloudyAutumn, cloudyWinter);
        int rainSpring = row.getInt("RAIN_PROBABILITY_SPRING");
        int rainSummer = row.getInt("RAIN_PROBABILITY_SUMMER");
        int rainAutumn = row.getInt("RAIN_PROBABILITY_AUTUMN");
        int rainWinter = row.getInt("RAIN_PROBABILITY_WINTER");
        WeatherTypeProbability rain = new WeatherTypeProbability(rainSpring, rainSummer, rainAutumn, rainWinter);
        return new WeatherTypeProbabilities(clear, cloudy, rain);
    }

    private WeatherTemperatureRanges getTemperatureRanges(ResultRow row) {
        int minimumSpring = row.getInt("TEMPERATURE_MINIMUM_SPRING");
        int maximumSpring = row.getInt("TEMPERATURE_MAXIMUM_SPRING");
        WeatherTemperatureRange spring = new WeatherTemperatureRange(minimumSpring, maximumSpring);
        int minimumSummer = row.getInt("TEMPERATURE_MINIMUM_SUMMER");
        int maximumSummer = row.getInt("TEMPERATURE_MAXIMUM_SUMMER");
        WeatherTemperatureRange summer = new WeatherTemperatureRange(minimumSummer, maximumSummer);
        int minimumAutumn = row.getInt("TEMPERATURE_MINIMUM_AUTUMN");
        int maximumAutumn = row.getInt("TEMPERATURE_MAXIMUM_AUTUMN");
        WeatherTemperatureRange autumn = new WeatherTemperatureRange(minimumAutumn, maximumAutumn);
        int minimumWinter = row.getInt("TEMPERATURE_MINIMUM_WINTER");
        int maximumWinter = row.getInt("TEMPERATURE_MAXIMUM_WINTER");
        WeatherTemperatureRange winter = new WeatherTemperatureRange(minimumWinter, maximumWinter);
        return new WeatherTemperatureRanges(spring, summer, autumn, winter);
    }

    private WeatherTemperatureExtremes getExtremeProbabilities(ResultRow row) {
        int probabilitySpring = row.getInt("TEMPERATURE_EXTREME_PROBABILITY_SPRING");
        int offsetSpring = row.getInt("TEMPERATURE_EXTREME_OFFSET_SPRING");
        WeatherTemperatureExtreme spring = new WeatherTemperatureExtreme(probabilitySpring, offsetSpring);
        int probabilitySummer = row.getInt("TEMPERATURE_EXTREME_PROBABILITY_SUMMER");
        int offsetSummer = row.getInt("TEMPERATURE_EXTREME_OFFSET_SUMMER");
        WeatherTemperatureExtreme summer = new WeatherTemperatureExtreme(probabilitySummer, offsetSummer);
        int probabilityAutumn = row.getInt("TEMPERATURE_EXTREME_PROBABILITY_AUTUMN");
        int offsetAutumn = row.getInt("TEMPERATURE_EXTREME_OFFSET_AUTUMN");
        WeatherTemperatureExtreme autumn = new WeatherTemperatureExtreme(probabilityAutumn, offsetAutumn);
        int probabilityWinter = row.getInt("TEMPERATURE_EXTREME_PROBABILITY_WINTER");
        int offsetWinter = row.getInt("TEMPERATURE_EXTREME_OFFSET_WINTER");
        WeatherTemperatureExtreme winter = new WeatherTemperatureExtreme(probabilityWinter, offsetWinter);
        return new WeatherTemperatureExtremes(spring, summer, autumn, winter);
    }

    private WeatherWindSpeedMaximums getWindSpeedMaximums(ResultRow row) {
        int spring = row.getInt("WIND_SPEED_MAXIMUM_SPRING");
        int summer = row.getInt("WIND_SPEED_MAXIMUM_SUMMER");
        int autumn = row.getInt("WIND_SPEED_MAXIMUM_AUTUMN");
        int winter = row.getInt("WIND_SPEED_MAXIMUM_WINTER");
        return new WeatherWindSpeedMaximums(spring, summer, autumn, winter);
    }
}

