/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.weather.event;

import com.equestricraft.base.eventbus.ECEventBus;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.core.weather.CurrentWeather;
import com.equestricraft.core.weather.WeatherSession;
import com.equestricraft.core.weather.event.WeatherEvent;
import com.equestricraft.core.weather.event.WeatherEventSession;
import com.equestricraft.core.weather.event.WindGustEvent;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class WeatherEventSessionImpl
implements WeatherEventSession {
    @Service
    private WeatherSession weatherSession;
    private final WeatherEventTimes weatherEventTimes = new WeatherEventTimes();

    @Override
    public void checkAndFireEvents() {
        Optional<Duration> durationSince;
        CurrentWeather currentWeather = this.weatherSession.getCurrentWeather();
        if (currentWeather.highWinds() && ((durationSince = this.weatherEventTimes.getDurationSince(WindGustEvent.class)).isEmpty() || durationSince.get().toSeconds() > 20L && (double)NumberUtils.nextFloat() > 0.8)) {
            WindGustEvent event = new WindGustEvent((double)currentWeather.windSpeed() * 1.2);
            ECEventBus.post(event);
            this.weatherEventTimes.setLastTime(event);
        }
    }

    private static class WeatherEventTimes {
        private final Map<Class<? extends WeatherEvent>, Long> eventTimes = new HashMap<Class<? extends WeatherEvent>, Long>();

        private WeatherEventTimes() {
        }

        public void setLastTime(WeatherEvent event) {
            this.eventTimes.put(event.getClass(), System.currentTimeMillis());
        }

        public Optional<Duration> getDurationSince(Class<? extends WeatherEvent> type) {
            Long timeStamp = this.eventTimes.get(type);
            if (timeStamp != null) {
                return Optional.of(DateUtils.durationSince(timeStamp));
            }
            return Optional.empty();
        }
    }
}

