/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.dataload;

import com.equestricraft.common.ListMap;
import com.equestricraft.dataload.DataLoadModule;
import com.equestricraft.dataload.DataLoadSender;
import com.equestricraft.dataload.DataLoadSubscriber;
import com.equestricraft.dataload.DataLoader;
import com.equestricraft.logging.Log;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractDataLoadController {
    private final Map<DataLoadModule, DataLoader> dataLoaderMap = new EnumMap<DataLoadModule, DataLoader>(DataLoadModule.class);
    private final DataLoadSender dataLoadSender = new DataLoadSender();
    private static final ListMap<DataLoadModule, DataLoadSubscriber> subscribers = new ListMap();
    private static final Log log = Log.getLogger(AbstractDataLoadController.class.getName());

    public void initialize() {
        List<? extends DataLoader> dataLoaders = this.getAllDataLoaders();
        dataLoaders.forEach(this::register);
        this.dataLoadSender.subscribe(this::loadModules);
    }

    public void register(DataLoader dataLoader) {
        this.dataLoaderMap.put(dataLoader.module(), dataLoader);
    }

    protected List<? extends DataLoader> getAllDataLoaders() {
        return new ArrayList(0);
    }

    private void loadModules(List<String> moduleIdentifiers) {
        for (String moduleIdentifier : moduleIdentifiers) {
            try {
                this.load(moduleIdentifier);
            }
            catch (Exception ex) {
                log.error(String.format("Error loading data for %s", moduleIdentifier), ex);
            }
        }
    }

    private void load(String moduleIdentifier) {
        DataLoadModule module = DataLoadModule.valueOf(moduleIdentifier);
        DataLoader loader = this.dataLoaderMap.get((Object)module);
        if (loader != null) {
            log.info("Loading data for {}", (Object)module.getDisplayName());
            loader.loadData();
            this.notifySubscribersForModule(module);
        }
    }

    protected static void addSubscriber(DataLoadSubscriber dataLoadSubscriber) {
        subscribers.add(dataLoadSubscriber.getModule(), dataLoadSubscriber);
    }

    private void notifySubscribersForModule(DataLoadModule module) {
        List<DataLoadSubscriber> moduleSubscribers = subscribers.get(module);
        moduleSubscribers.forEach(DataLoadSubscriber::fireUpdate);
    }
}

