/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.featureflag;

import com.equestricraft.featureflag.FeatureFlagStateCache;
import java.util.Arrays;
import java.util.Optional;

public enum FeatureFlag {
    PLAYER_INDUCTION("Player Induction", "The player induction mode which restricts functionality for new players"),
    ADVANCED_SPEED_CONTROL("Advanced Speed Control", "Advanced speed control for horses"),
    PROVISIONS_AFFECT_STATS("Provisions affect stats", "If the horses provision levels should affect stats"),
    DISCIPLINE_CERTIFICATION("Discipline Certification", "If horses need their disciplines certified"),
    MARE_HEAT("Mare Heat", "If the mare heat should be enabled or not"),
    DEATH_REGISTRATION("Death Registration", "If death registration should be enabled or not"),
    NATURAL_PLOTS("Natural Plots", "If the natural plot world should be available"),
    WEATHER_AFFECTS_HORSES("Weather Affects Horses", "If weather should affect horses"),
    WARMING_UP("Warming Up", "If horses should need to warm up for speeds"),
    STAMINA("Stamina", "If stamina should affect horses"),
    TRUST_OBEY("Trust Obeying", "If horses should obey players based on their trust with the player"),
    ACTION_REJECT("Action Reject", "If horses should reject actions"),
    PERFORM_LEARNED_ACTIONS("Perform Learned Actions", "If horses should perform learned actions"),
    FEED_CONTAINER("Feed Containers", "If feed containers should be enabled or not"),
    STAT_EFFECTS("Stats Effects", "If speed and jump should be affected by other factors"),
    RELATIONSHIPS("Relationships", "If horses should have relationships between them"),
    SHOES_FALLING_OFF("Shoes Falling Off", "If a horses shoes should be able to fall off"),
    ILLNESSES("Illnesses", "If illnesses should be processed"),
    BREEDING("Breeding", "Horses breeding with eachother and getting pregnant");

    private final String name;
    private final String description;

    private FeatureFlag(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        FeatureFlagStateCache cache = FeatureFlagStateCache.getInstance();
        return cache.isEnabled(this);
    }

    public boolean isDisabled() {
        return !this.isEnabled();
    }

    static boolean doesFlagExist(String identifier) {
        for (FeatureFlag flag : FeatureFlag.values()) {
            if (!flag.name().equals(identifier)) continue;
            return true;
        }
        return false;
    }

    public static Optional<FeatureFlag> findFlag(String identifier) {
        return Arrays.stream(FeatureFlag.values()).filter(f -> f.name.equals(identifier)).findFirst();
    }
}

