/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.featureflag;

import com.equestricraft.featureflag.FeatureFlag;
import com.equestricraft.featureflag.FeatureFlagDataSource;
import com.equestricraft.featureflag.FeatureFlagRecord;
import com.equestricraft.featureflag.FeatureFlagStateCache;
import com.equestricraft.logging.Log;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class FeatureFlags {
    private static final FeatureFlags instance = new FeatureFlags();
    private FeatureFlagDataSource featureFlagDataSource = null;
    private final FeatureFlagStateCache featureFlagStateCache = FeatureFlagStateCache.getInstance();
    private static final Log log = Log.getLogger(FeatureFlags.class.getName());

    public static FeatureFlags getInstance() {
        return instance;
    }

    private FeatureFlags() {
    }

    public Map<FeatureFlag, Boolean> load(FeatureFlagDataSource featureFlagDataSource) {
        log.info("Loading feature flags");
        this.featureFlagDataSource = featureFlagDataSource;
        List<FeatureFlagRecord> flagsInDatasource = featureFlagDataSource.getAllFeatureFlags();
        this.deleteRemovedFlags(flagsInDatasource);
        for (FeatureFlagRecord featureFlag : flagsInDatasource) {
            FeatureFlag flag = FeatureFlag.valueOf(featureFlag.identifier());
            this.featureFlagStateCache.setEnabled(flag, featureFlag.state());
        }
        this.updateFlags();
        return Collections.unmodifiableMap(this.featureFlagStateCache.getStates());
    }

    private void deleteRemovedFlags(List<FeatureFlagRecord> featureFlagRecords) {
        List<String> toDelete = featureFlagRecords.stream().map(FeatureFlagRecord::identifier).filter(Predicate.not(FeatureFlag::doesFlagExist)).toList();
        toDelete.forEach(this.featureFlagDataSource::deleteFlag);
        if (!toDelete.isEmpty()) {
            log.info("Removed {} feature flags", (Object)String.join((CharSequence)", ", toDelete));
        }
    }

    private void updateFlags() {
        List<FeatureFlag> flags = Arrays.stream(FeatureFlag.values()).toList();
        flags.forEach(this.featureFlagDataSource::updateFlag);
    }

    public void updateFlagState(FeatureFlag flag, boolean newState) {
        this.featureFlagStateCache.setEnabled(flag, newState);
    }
}

