/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.groovy;

import com.equestricraft.groovy.GroovySessionData;
import com.equestricraft.groovy.prompt.GroovyPromptResponse;
import java.util.Optional;

public class GroovyPromptContext {
    private static final ThreadLocal<GroovyPromptContext> contextLocal = new ThreadLocal();
    private static final String PROMPT_RESPONSE_PREFIX = "promptResponse_";
    private final GroovySessionData groovySessionData;

    public static void init(GroovySessionData sessionData) {
        GroovyPromptContext context = new GroovyPromptContext(sessionData);
        contextLocal.set(context);
    }

    public static void setResponse(GroovyPromptResponse response) {
        GroovyPromptContext.contextLocal.get().groovySessionData.put(PROMPT_RESPONSE_PREFIX + response.identifier(), response.value());
    }

    public static Optional<Object> getResponse(String identifier) {
        Object response = GroovyPromptContext.contextLocal.get().groovySessionData.get(PROMPT_RESPONSE_PREFIX + identifier);
        return Optional.ofNullable(response);
    }

    public static void clearContext() {
        contextLocal.remove();
    }

    private GroovyPromptContext(GroovySessionData groovySessionData) {
        this.groovySessionData = groovySessionData;
    }
}

