/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.groovy;

import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.GroovyScriptEngine;
import groovy.lang.Binding;
import groovy.lang.GString;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class GroovyScript {
    private static final String IMPORTS = GroovyScript.createImports();

    private GroovyScript() {
    }

    public static <T> T run(String scriptText, Binding binding) throws GroovyException {
        Object value = GroovyScriptEngine.run(scriptText = GroovyScript.attachCommonImports(scriptText), binding);
        if (value instanceof GString) {
            GString gString = (GString)value;
            return (T)gString.toString();
        }
        return value;
    }

    private static String attachCommonImports(String scriptText) {
        return String.format("%s%n%n%s", IMPORTS, scriptText);
    }

    private static String createImports() {
        List<String> imports = GroovyScript.createImportsList();
        return imports.stream().map(GroovyScript::createImportString).collect(Collectors.joining("\n"));
    }

    private static String createImportString(String s) {
        return String.format("import %s", s);
    }

    private static List<String> createImportsList() {
        LinkedList<String> imports = new LinkedList<String>();
        GroovyScript.attachCoreImports(imports);
        GroovyScript.attachAdditionalImports(imports);
        return imports;
    }

    private static void attachCoreImports(List<String> imports) {
        imports.add("com.equestricraft.api.common.*");
        imports.add("com.equestricraft.api.groovy.*");
        imports.add("com.equestricraft.api.rules.*");
        imports.add("com.equestricraft.logging.Log");
    }

    private static void attachAdditionalImports(List<String> imports) {
        imports.add("java.time.Duration");
    }
}

