/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.groovy;

import com.equestricraft.common.GroovyInvalidStrings;
import com.equestricraft.groovy.GroovyException;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.util.Objects;

public class GroovyScriptEngine {
    public static <T> T run(String scriptText, Binding binding) throws GroovyException {
        Objects.requireNonNull(scriptText, "Must supply a script");
        if (scriptText.isEmpty()) {
            throw new GroovyException("Blank script provided");
        }
        GroovyScriptEngine.ensureNoInvalidPatterns(scriptText);
        try {
            GroovyShell shell = new GroovyShell(binding);
            return (T)shell.evaluate(scriptText);
        }
        catch (Throwable ex) {
            throw new GroovyException(ex);
        }
    }

    private static void ensureNoInvalidPatterns(String script) throws GroovyException {
        boolean hasInvalid = GroovyInvalidStrings.getDisallowedStrings().stream().anyMatch(script::contains);
        if (hasInvalid) {
            throw new GroovyException("Invalid text in groovy script");
        }
    }

    private GroovyScriptEngine() {
    }
}

