/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.groovy;

import com.equestricraft.api.common.APIDurationDto;
import com.equestricraft.api.common.APIGroovySessionData;
import com.equestricraft.api.common.APILocationDto;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GroovySessionData
implements APIGroovySessionData {
    private final Map<String, Object> data;
    private static final String VALUE_NAME_REGEX = "^[a-zA-Z0-9]+$";
    private static final String TYPE_STRING = "String";
    private static final String TYPE_INTEGER = "Integer";
    private static final String TYPE_DOUBLE = "Double";
    private static final String TYPE_LONG = "Long";
    private static final String TYPE_FLOAT = "Float";
    private static final String TYPE_BOOLEAN = "Boolean";
    private static final String TYPE_DURATION = "Duration";
    private static final String TYPE_LOCATION = "Location";
    private static final String TYPE_LIST = "List";

    public GroovySessionData() {
        this(new HashMap<String, Object>(0));
    }

    public GroovySessionData(Map<String, Object> data) {
        this.data = data;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.data.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.data.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.data.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.data.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.data.putAll(m);
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.data.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.data.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.data.entrySet();
    }

    @Override
    public String getString(String name) {
        this.ensureNameIsValid(name);
        return (String)this.data.get(name);
    }

    @Override
    public void setString(String name, String value) {
        this.ensureNameIsValid(name);
        this.data.put(name, value);
    }

    @Override
    public Integer getInteger(String name) {
        return (Integer)this.data.get(name);
    }

    @Override
    public void setInteger(String name, Integer value) {
        this.ensureNameIsValid(name);
        this.data.put(name, value);
    }

    @Override
    public Double getDouble(String name) {
        return (Double)this.data.get(name);
    }

    @Override
    public void setDouble(String name, Double value) {
        this.ensureNameIsValid(name);
        this.data.put(name, value);
    }

    @Override
    public Long getLong(String name) {
        return (Long)this.data.get(name);
    }

    @Override
    public void setLong(String name, Long value) {
        this.ensureNameIsValid(name);
        this.data.put(name, value);
    }

    @Override
    public Float getFloat(String name) {
        return (Float)this.data.get(name);
    }

    @Override
    public void setFloat(String name, Float value) {
        this.ensureNameIsValid(name);
        this.data.put(name, value);
    }

    @Override
    public Boolean getBoolean(String name) {
        return (Boolean)this.data.get(name);
    }

    @Override
    public void setBoolean(String name, Boolean value) {
        this.ensureNameIsValid(name);
        this.data.put(name, value);
    }

    @Override
    public APIDurationDto getDuration(String name) {
        return (APIDurationDto)this.data.get(name);
    }

    @Override
    public void setDuration(String name, APIDurationDto value) {
        this.ensureNameIsValid(name);
        this.data.put(name, value);
    }

    @Override
    public APILocationDto getLocation(String name) {
        return (APILocationDto)this.data.get(name);
    }

    @Override
    public void setLocation(String name, APILocationDto value) {
        this.ensureNameIsValid(name);
        this.data.put(name, value);
    }

    @Override
    public List<Object> getList(String name) {
        return (List)this.data.get(name);
    }

    @Override
    public void setList(String name, List<Object> value) {
        this.ensureNameIsValid(name);
        this.data.put(name, value);
    }

    @Override
    public boolean has(String name) {
        this.ensureNameIsValid(name);
        return this.data.containsKey(name);
    }

    @Override
    public <T> T remove(String name) {
        this.ensureNameIsValid(name);
        return (T)this.data.remove(name);
    }

    public void merge(GroovySessionData groovySessionData) {
        this.data.putAll(groovySessionData.data);
    }

    public Map<String, Object> getData() {
        return Collections.unmodifiableMap(this.data);
    }

    private void ensureNameIsValid(String name) {
        if (!name.matches(VALUE_NAME_REGEX)) {
            throw new IllegalArgumentException(String.format("Invalid value name: %s", name));
        }
    }

    public void serialize(DataOutputStream outputStream2) throws IOException {
        outputStream2.writeInt(this.data.size());
        for (Map.Entry<String, Object> entry : this.data.entrySet()) {
            outputStream2.writeUTF(entry.getKey());
            Object value = entry.getValue();
            if (value != null) {
                outputStream2.writeBoolean(true);
                this.serializeValue(outputStream2, value);
                continue;
            }
            outputStream2.writeBoolean(false);
        }
    }

    private void serializeValue(DataOutputStream outputStream2, Object value) throws IOException {
        if (value instanceof String) {
            String stringValue = (String)value;
            outputStream2.writeUTF(TYPE_STRING);
            outputStream2.writeUTF(stringValue);
        } else if (value instanceof Integer) {
            Integer integerValue = (Integer)value;
            outputStream2.writeUTF(TYPE_INTEGER);
            outputStream2.writeInt(integerValue);
        } else if (value instanceof Double) {
            Double doubleValue = (Double)value;
            outputStream2.writeUTF(TYPE_DOUBLE);
            outputStream2.writeDouble(doubleValue);
        } else if (value instanceof Long) {
            Long longValue = (Long)value;
            outputStream2.writeUTF(TYPE_LONG);
            outputStream2.writeLong(longValue);
        } else if (value instanceof Float) {
            Float floatValue = (Float)value;
            outputStream2.writeUTF(TYPE_FLOAT);
            outputStream2.writeFloat(floatValue.floatValue());
        } else if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            outputStream2.writeUTF(TYPE_BOOLEAN);
            outputStream2.writeBoolean(booleanValue);
        } else if (value instanceof APIDurationDto) {
            APIDurationDto durationValue = (APIDurationDto)value;
            outputStream2.writeUTF(TYPE_DURATION);
            outputStream2.writeLong(durationValue.getMillis());
        } else if (value instanceof APILocationDto) {
            APILocationDto locationValue = (APILocationDto)value;
            outputStream2.writeUTF(TYPE_LOCATION);
            String locationString = this.serializeLocation(locationValue);
            outputStream2.writeUTF(locationString);
        } else if (value instanceof List) {
            List list = (List)value;
            outputStream2.writeUTF(TYPE_LIST);
            outputStream2.writeInt(list.size());
            for (Object item : list) {
                this.serializeValue(outputStream2, item);
            }
        } else {
            throw new IllegalArgumentException(String.format("Invalid type: %s", value.getClass().getName()));
        }
    }

    private String serializeLocation(APILocationDto locationValue) {
        return String.format("%s,%s,%s,%s,%s,%s", locationValue.getX(), locationValue.getY(), locationValue.getZ(), locationValue.getDimension(), Float.valueOf(locationValue.getRotationY()), Float.valueOf(locationValue.getRotationX()));
    }

    public static GroovySessionData deserialize(DataInputStream inputStream2) throws IOException {
        int size = inputStream2.readInt();
        HashMap<String, Object> data = new HashMap<String, Object>(size);
        for (int i = 0; i < size; ++i) {
            String name = inputStream2.readUTF();
            boolean hasValue = inputStream2.readBoolean();
            if (!hasValue) {
                data.put(name, null);
                continue;
            }
            Object value = GroovySessionData.deserializeValue(inputStream2);
            data.put(name, value);
        }
        return new GroovySessionData(data);
    }

    private static Object deserializeValue(DataInputStream inputStream2) throws IOException {
        String type;
        return switch (type = inputStream2.readUTF()) {
            case TYPE_STRING -> inputStream2.readUTF();
            case TYPE_INTEGER -> inputStream2.readInt();
            case TYPE_DOUBLE -> inputStream2.readDouble();
            case TYPE_LONG -> inputStream2.readLong();
            case TYPE_FLOAT -> Float.valueOf(inputStream2.readFloat());
            case TYPE_BOOLEAN -> inputStream2.readBoolean();
            case TYPE_DURATION -> new APIDurationDto(Duration.ofMillis(inputStream2.readLong()));
            case TYPE_LOCATION -> GroovySessionData.deserializeLocation(inputStream2);
            case TYPE_LIST -> GroovySessionData.deserializeList(inputStream2);
            default -> throw new IllegalArgumentException(String.format("Invalid type: %s", type));
        };
    }

    private static APILocationDto deserializeLocation(DataInputStream inputStream2) throws IOException {
        String locationString = inputStream2.readUTF();
        String[] parts = locationString.split(",");
        double x = Double.parseDouble(parts[0]);
        double y = Double.parseDouble(parts[1]);
        double z = Double.parseDouble(parts[2]);
        String dimension = parts[3];
        float rotationY = Float.parseFloat(parts[4]);
        float rotationX = Float.parseFloat(parts[5]);
        return new APILocationDto(x, y, z, dimension, rotationY, rotationX);
    }

    private static List<Object> deserializeList(DataInputStream inputStream2) throws IOException {
        int size = inputStream2.readInt();
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < size; ++i) {
            Object value = GroovySessionData.deserializeValue(inputStream2);
            list.add(value);
        }
        return list;
    }
}

