/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.groovy.executor;

import com.equestricraft.api.rules.GroovyPromptException;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.GroovyPromptContext;
import com.equestricraft.groovy.GroovyPromptNeededException;
import com.equestricraft.groovy.executor.GroovyScriptExecutor;
import com.equestricraft.groovy.executor.GroovyScriptResponse;
import com.equestricraft.groovy.prompt.GroovyPromptRequestTransformer;
import com.equestricraft.groovy.prompt.request.GroovyPromptRequest;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.Script;
import java.util.List;
import java.util.Map;

public class GroovyPromptScriptExecutor
extends GroovyScriptExecutor<GroovyPromptScriptExecutor> {
    private final GroovyPromptRequestTransformer groovyPromptRequestTransformer = GroovyPromptRequestTransformer.getInstance();

    private GroovyPromptScriptExecutor(String script, Script scriptObject, Closure<?> scriptClosure) {
        super(script, scriptObject, scriptClosure);
    }

    public GroovyScriptResponse<Void> execute() throws GroovyException, GroovyPromptNeededException {
        this.ensureNotExecuted();
        Binding binding = this.createBinding();
        List<String> preVariables = this.getVariableNamesFromBinding(binding);
        this.attachRootVariables(binding);
        try {
            this.runScript(binding);
            this.hasBeenExecuted = true;
            Map<String, Object> variables = this.getResultVariables(binding);
            Map<String, Object> extraVariables = this.getNewlyDefinedVariables(binding, preVariables);
            GroovyPromptContext.clearContext();
            return new GroovyScriptResponse<Object>(variables, null, extraVariables);
        }
        catch (GroovyException ex) {
            Throwable throwable = ex.getCause();
            if (throwable instanceof GroovyPromptException) {
                GroovyPromptException pex = (GroovyPromptException)throwable;
                GroovyPromptRequest request = this.groovyPromptRequestTransformer.transformMapToGroovyPromptRequest(pex.getPrompt());
                throw new GroovyPromptNeededException(request);
            }
            throw ex;
        }
    }

    public static GroovyPromptScriptExecutor start(String script) {
        return new GroovyPromptScriptExecutor(script, null, null);
    }

    public static GroovyPromptScriptExecutor start(Script script) {
        return new GroovyPromptScriptExecutor(null, script, null);
    }

    public static GroovyPromptScriptExecutor start(Closure<?> script) {
        return new GroovyPromptScriptExecutor(null, null, script);
    }
}

