/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.groovy.executor;

import com.equestricraft.api.rules.RuleContextData;
import com.equestricraft.api.rules.RuleFailException;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.GroovyPromptContext;
import com.equestricraft.groovy.executor.GroovyRuleFailFunction;
import com.equestricraft.groovy.executor.GroovyScriptExecutor;
import com.equestricraft.groovy.executor.GroovyScriptResponse;
import com.equestricraft.groovy.executor.RuleScriptResponse;
import com.equestricraft.groovy.prompt.request.GroovyMessagePromptRequest;
import com.equestricraft.groovy.prompt.request.GroovyPromptType;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.Script;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class GroovyRuleScriptExecutor
extends GroovyScriptExecutor<GroovyRuleScriptExecutor> {
    private GroovyRuleScriptExecutor(String script, Script scriptObject, Closure<?> scriptClosure) {
        super(script, scriptObject, scriptClosure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroovyScriptResponse<RuleScriptResponse> execute() throws GroovyException {
        this.ensureNotExecuted();
        Binding binding = this.createBinding();
        GroovyRuleFailFunction failFunction = new GroovyRuleFailFunction();
        binding.setVariable("fail", failFunction);
        RuleContextData.setData("horse", this.horse);
        RuleContextData.setData("player", this.player);
        RuleContextData.setData("global", this.global);
        RuleContextData.setData("config", this.config);
        List<String> preVariables = this.getVariableNamesFromBinding(binding);
        this.attachRootVariables(binding);
        try {
            Boolean resultBoolean;
            Object result = this.runScript(binding);
            this.hasBeenExecuted = true;
            Map<String, Object> variables = this.getResultVariables(binding);
            Map<String, Object> extraVariables = this.getNewlyDefinedVariables(binding, preVariables);
            GroovyPromptContext.clearContext();
            if (result instanceof Boolean && Boolean.TRUE.equals((resultBoolean = (Boolean)result) == false)) {
                GroovyScriptResponse<RuleScriptResponse> groovyScriptResponse = new GroovyScriptResponse<RuleScriptResponse>(variables, RuleScriptResponse.rulePassed(), extraVariables);
                return groovyScriptResponse;
            }
            GroovyScriptResponse<RuleScriptResponse> groovyScriptResponse = new GroovyScriptResponse<RuleScriptResponse>(variables, RuleScriptResponse.rulePassed(), extraVariables);
            return groovyScriptResponse;
        }
        catch (GroovyException ex) {
            Object object = ex.getCause();
            if (object instanceof RuleFailException) {
                RuleFailException rex = (RuleFailException)object;
                object = this.processFailure(binding, rex);
                return object;
            }
            throw ex;
        }
        catch (RuleFailException ex) {
            GroovyScriptResponse<RuleScriptResponse> groovyScriptResponse = this.processFailure(binding, ex);
            return groovyScriptResponse;
        }
        finally {
            RuleContextData.clear();
        }
    }

    private GroovyScriptResponse<RuleScriptResponse> processFailure(Binding binding, RuleFailException rex) {
        GroovyPromptContext.clearContext();
        Map<String, Object> variables = this.getResultVariables(binding);
        GroovyMessagePromptRequest prompt = new GroovyMessagePromptRequest("RULE_FAIL", rex.getPromptTitle(), rex.getPromptMessage(), GroovyPromptType.ERROR);
        return new GroovyScriptResponse<RuleScriptResponse>(variables, RuleScriptResponse.ruleFailed(prompt), Collections.emptyMap());
    }

    public static GroovyRuleScriptExecutor start(String script) {
        return new GroovyRuleScriptExecutor(script, null, null);
    }

    public static GroovyRuleScriptExecutor start(Script script) {
        return new GroovyRuleScriptExecutor(null, script, null);
    }

    public static GroovyRuleScriptExecutor start(Closure<?> script) {
        return new GroovyRuleScriptExecutor(null, null, script);
    }
}

