/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.groovy.executor;

import com.equestricraft.api.common.APIConfigDto;
import com.equestricraft.api.common.APIGlobalDto;
import com.equestricraft.api.common.APIHorseDto;
import com.equestricraft.api.common.APIPlayerDto;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.GroovyPromptContext;
import com.equestricraft.groovy.GroovyScript;
import com.equestricraft.groovy.GroovyScriptSessionData;
import com.equestricraft.groovy.GroovySessionData;
import com.equestricraft.groovy.prompt.PromptHandlerMap;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.Script;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class GroovyScriptExecutor<T extends GroovyScriptExecutor<?>> {
    private final String script;
    private final Script scriptObject;
    private final Closure<?> scriptClosure;
    protected APIPlayerDto player = null;
    protected APIHorseDto horse = null;
    protected APIGlobalDto global = null;
    protected APIConfigDto config = null;
    protected final Map<String, Object> variables = new HashMap<String, Object>();
    protected final Map<String, Object> rootVariables = new HashMap<String, Object>();
    protected GroovyScriptSessionData sessionData = null;
    protected boolean hasBeenExecuted = false;

    GroovyScriptExecutor(String script, Script scriptObject, Closure<?> scriptClosure) {
        this.script = script;
        this.scriptObject = scriptObject;
        this.scriptClosure = scriptClosure;
    }

    public T withPlayer(APIPlayerDto player) {
        this.ensureNotExecuted();
        this.player = player;
        return (T)this;
    }

    public T withHorse(APIHorseDto horse) {
        this.ensureNotExecuted();
        this.horse = horse;
        return (T)this;
    }

    public T withGlobal(APIGlobalDto global) {
        this.ensureNotExecuted();
        this.global = global;
        return (T)this;
    }

    public T withConfig(APIConfigDto config) {
        this.ensureNotExecuted();
        this.config = config;
        return (T)this;
    }

    public T withVariable(String name, Object value) {
        this.ensureNotExecuted();
        this.ensureVariableNameNotProtected(name);
        this.variables.put(name, value);
        return (T)this;
    }

    public T withBlankVariable(String name) {
        return this.withVariable(name, null);
    }

    public T withRootVariable(String name, Object value) {
        this.ensureNotExecuted();
        this.ensureVariableNameNotProtected(name);
        this.rootVariables.put(name, value);
        return (T)this;
    }

    public T withSessionData(GroovyScriptSessionData sessionData) {
        this.ensureNotExecuted();
        this.sessionData = sessionData;
        return (T)this;
    }

    protected void ensureNotExecuted() {
        if (this.hasBeenExecuted) {
            throw new IllegalStateException("This script executor has already been run");
        }
    }

    Binding createBinding() {
        Binding binding = new Binding();
        binding.setVariable("prompt", new PromptHandlerMap());
        GroovySessionData data = this.sessionData == null ? new GroovySessionData() : this.sessionData.data();
        binding.setVariable("sessionData", data);
        binding.setVariable("session", data);
        binding.setVariable("variable", data);
        GroovyPromptContext.init(data);
        if (this.player != null) {
            binding.setVariable("player", this.player);
        }
        if (this.horse != null) {
            binding.setVariable("horse", this.horse);
        }
        if (this.global != null) {
            binding.setVariable("global", this.global);
        }
        if (this.config != null) {
            binding.setVariable("config", this.config);
        }
        for (Map.Entry<String, Object> variable : this.variables.entrySet()) {
            binding.setVariable(variable.getKey(), variable.getValue());
        }
        return binding;
    }

    private void ensureVariableNameNotProtected(String variableName) {
        if (this.isVariableNameProtected(variableName)) {
            throw new IllegalArgumentException(String.format("Provided variable name is protected: %s", variableName));
        }
    }

    private boolean isVariableNameProtected(String variableName) {
        return variableName.startsWith("internal_") || variableName.equals("horse") || variableName.equals("player") || variableName.equals("sessionData") || variableName.equals("session") || variableName.equals("variable");
    }

    protected Map<String, Object> getResultVariables(Binding binding) {
        HashMap<String, Object> newMap = new HashMap<String, Object>(this.variables.size());
        for (String variableName : this.variables.keySet()) {
            Object fromBinding = binding.getVariable(variableName);
            newMap.put(variableName, fromBinding);
        }
        return newMap;
    }

    <R> R runScript(Binding binding) throws GroovyException {
        if (this.script != null) {
            return (R)GroovyScript.run(this.script, binding);
        }
        if (this.scriptClosure != null) {
            return (R)this.scriptClosure.call();
        }
        this.scriptObject.setBinding(binding);
        return (R)this.scriptObject.run();
    }

    final List<String> getVariableNamesFromBinding(Binding binding) {
        ArrayList<String> variableNames = new ArrayList<String>(binding.getVariables().size());
        for (Object variable : binding.getVariables().keySet()) {
            variableNames.add(variable.toString());
        }
        return variableNames;
    }

    final void attachRootVariables(Binding binding) {
        this.rootVariables.entrySet().stream().filter(Predicate.not(v -> binding.hasVariable((String)v.getKey()))).forEach(v -> binding.setVariable((String)v.getKey(), v.getValue()));
    }

    final Map<String, Object> getNewlyDefinedVariables(Binding binding, List<String> preVariables) {
        List<String> postVariables = this.getVariableNamesFromBinding(binding);
        return postVariables.stream().filter(Predicate.not(preVariables::contains)).filter(this::isAllowedVariableName).filter(v -> binding.getVariable((String)v) != null).collect(Collectors.toMap(Function.identity(), binding::getVariable));
    }

    private boolean isAllowedVariableName(String name) {
        return !this.isVariableNameProtected(name);
    }
}

