/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.groovy.executor;

import groovy.lang.GString;
import java.time.Duration;
import java.util.List;
import java.util.Map;

public record GroovyScriptResponse<T>(Map<String, Object> variables, T result, Map<String, Object> extraDefinedVariables) {
    public Object getVariable(String name) {
        return this.variables.get(name);
    }

    public String getStringVariable(String name) {
        Object variable = this.getVariable(name);
        if (variable instanceof GString) {
            GString gString = (GString)variable;
            return gString.toString();
        }
        return (String)this.getVariable(name);
    }

    public Number getNumberVariable(String name) {
        return (Number)this.getVariable(name);
    }

    public Integer getIntegerVariable(String name) {
        Number number = this.getNumberVariable(name);
        if (number == null) {
            return null;
        }
        return number.intValue();
    }

    public Float getFloatVariable(String name) {
        Number number = this.getNumberVariable(name);
        if (number == null) {
            return null;
        }
        return Float.valueOf(number.floatValue());
    }

    public Double getDoubleVariable(String name) {
        Number number = this.getNumberVariable(name);
        if (number == null) {
            return null;
        }
        return number.doubleValue();
    }

    public Long getLongVariable(String name) {
        Number number = this.getNumberVariable(name);
        if (number == null) {
            return null;
        }
        return number.longValue();
    }

    public Boolean getBooleanVariable(String name) {
        return (Boolean)this.getVariable(name);
    }

    public Duration getDurationVariable(String name) {
        return (Duration)this.getVariable(name);
    }

    public <L> List<L> getListVariable(String name) {
        return (List)this.getVariable(name);
    }
}

