/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.groovy.prompt;

import com.equestricraft.api.common.prompt.APIMessagePrompt;
import com.equestricraft.api.common.prompt.APINumberInputPrompt;
import com.equestricraft.api.common.prompt.APIOptionPrompt;
import com.equestricraft.api.common.prompt.APIPrompt;
import com.equestricraft.api.common.prompt.APITextInputPrompt;
import com.equestricraft.api.common.prompt.APIYesNoPrompt;
import com.equestricraft.groovy.prompt.request.GroovyMessagePromptRequest;
import com.equestricraft.groovy.prompt.request.GroovyNumberInputPromptRequest;
import com.equestricraft.groovy.prompt.request.GroovyOptionPromptRequest;
import com.equestricraft.groovy.prompt.request.GroovyOptionPromptValue;
import com.equestricraft.groovy.prompt.request.GroovyPromptRequest;
import com.equestricraft.groovy.prompt.request.GroovyPromptType;
import com.equestricraft.groovy.prompt.request.GroovyTextInputPromptRequest;
import com.equestricraft.groovy.prompt.request.GroovyYesNoPromptRequest;
import java.util.List;
import java.util.Map;

public class GroovyPromptRequestTransformer {
    private static final GroovyPromptRequestTransformer instance = new GroovyPromptRequestTransformer();

    public static GroovyPromptRequestTransformer getInstance() {
        return instance;
    }

    private GroovyPromptRequestTransformer() {
    }

    public GroovyPromptRequest transformMapToGroovyPromptRequest(APIPrompt prompt) {
        if (prompt instanceof APIMessagePrompt) {
            APIMessagePrompt messagePrompt = (APIMessagePrompt)prompt;
            return this.buildMessagePrompt(messagePrompt);
        }
        if (prompt instanceof APITextInputPrompt) {
            APITextInputPrompt textInputPrompt = (APITextInputPrompt)prompt;
            return this.buildTextInputPrompt(textInputPrompt);
        }
        if (prompt instanceof APINumberInputPrompt) {
            APINumberInputPrompt numberInputPrompt = (APINumberInputPrompt)prompt;
            return this.buildNumberInputPrompt(numberInputPrompt);
        }
        if (prompt instanceof APIOptionPrompt) {
            APIOptionPrompt optionPrompt = (APIOptionPrompt)prompt;
            return this.buildSingleSelectionOptionInputPrompt(optionPrompt);
        }
        if (prompt instanceof APIYesNoPrompt) {
            APIYesNoPrompt yesNoPrompt = (APIYesNoPrompt)prompt;
            return this.buildYesNoInputPrompt(yesNoPrompt);
        }
        throw new IllegalArgumentException(String.format("Invalid prompt object: %s", prompt.getClass().getName()));
    }

    private GroovyMessagePromptRequest buildMessagePrompt(APIMessagePrompt messagePrompt) {
        return new GroovyMessagePromptRequest(messagePrompt.getIdentifier(), messagePrompt.getTitle(), messagePrompt.getMessage(), GroovyPromptType.valueOf(messagePrompt.getType()));
    }

    private GroovyTextInputPromptRequest buildTextInputPrompt(APITextInputPrompt textInputPrompt) {
        return new GroovyTextInputPromptRequest(textInputPrompt.getIdentifier(), textInputPrompt.getTitle(), textInputPrompt.getMessage(), textInputPrompt.getMinimumLength(), textInputPrompt.getMaximumLength());
    }

    private GroovyNumberInputPromptRequest buildNumberInputPrompt(APINumberInputPrompt numberInputPrompt) {
        return new GroovyNumberInputPromptRequest(numberInputPrompt.getIdentifier(), numberInputPrompt.getTitle(), numberInputPrompt.getMessage(), numberInputPrompt.getMinimumValue(), numberInputPrompt.getMaximumValue(), numberInputPrompt.getDecimalPoints());
    }

    private GroovyOptionPromptRequest buildSingleSelectionOptionInputPrompt(APIOptionPrompt optionPrompt) {
        return new GroovyOptionPromptRequest(optionPrompt.getIdentifier(), optionPrompt.getTitle(), optionPrompt.getMessage(), this.transformApiPromptOptionsToOptionPromptValues(optionPrompt.getOptions()), optionPrompt.isMultiSelection());
    }

    private List<GroovyOptionPromptValue> transformApiPromptOptionsToOptionPromptValues(List<Map<String, Object>> options) {
        return options.stream().map(this::transformApiPromptOptionToPromptOptionValue).toList();
    }

    private GroovyOptionPromptValue transformApiPromptOptionToPromptOptionValue(Map<String, Object> option) {
        return new GroovyOptionPromptValue((Integer)option.get("id"), (String)option.get("label"), (String)option.get("description"));
    }

    private GroovyYesNoPromptRequest buildYesNoInputPrompt(APIYesNoPrompt yesNoPrompt) {
        return new GroovyYesNoPromptRequest(yesNoPrompt.getIdentifier(), yesNoPrompt.getTitle(), yesNoPrompt.getMessage());
    }
}

