/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.groovy.prompt;

import com.equestricraft.api.common.prompt.APIMessagePrompt;
import com.equestricraft.api.common.prompt.APINumberInputPrompt;
import com.equestricraft.api.common.prompt.APIOptionPrompt;
import com.equestricraft.api.common.prompt.APIPrompt;
import com.equestricraft.api.common.prompt.APITextInputPrompt;
import com.equestricraft.api.common.prompt.APIYesNoPrompt;
import com.equestricraft.api.common.prompt.Prompt;
import com.equestricraft.api.rules.GroovyPromptException;
import com.equestricraft.groovy.GroovyPromptContext;
import groovy.lang.Closure;
import java.util.List;
import java.util.Optional;

public class PromptHandler
implements Prompt {
    private final String identifier;

    public PromptHandler(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public void alert(Closure<?> config) {
        this.setPrompt(config, new APIMessagePrompt(this.identifier));
    }

    @Override
    public String textInput(Closure<?> config) {
        return (String)this.setPrompt(config, new APITextInputPrompt(this.identifier));
    }

    @Override
    public Number numberInput(Closure<?> config) {
        return (Number)this.setPrompt(config, new APINumberInputPrompt(this.identifier));
    }

    @Override
    public Integer optionSelectSingle(Closure<?> config) {
        APIOptionPrompt prompt = new APIOptionPrompt(this.identifier);
        prompt.setMultiSelection(false);
        return (Integer)this.setPrompt(config, prompt);
    }

    @Override
    public List<Integer> optionSelectMulti(Closure<?> config) {
        APIOptionPrompt prompt = new APIOptionPrompt(this.identifier);
        prompt.setMultiSelection(true);
        return (List)this.setPrompt(config, prompt);
    }

    @Override
    public Boolean confirm(Closure<?> config) {
        return (Boolean)this.setPrompt(config, new APIYesNoPrompt(this.identifier));
    }

    private <T extends APIPrompt, R> R setPrompt(Closure<?> closure, T prompt) {
        Optional<Object> response = GroovyPromptContext.getResponse(prompt.getIdentifier());
        if (response.isPresent()) {
            return (R)response.get();
        }
        closure.setDelegate(prompt);
        closure.call();
        throw new GroovyPromptException(prompt);
    }
}

